/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static final boolean rmdir(String path, boolean failIfNotEmpty) {
        return FileUtil.rmdir(new File(path), failIfNotEmpty);
    }

    public static final boolean rmdir(File target, boolean failIfNotEmpty) {
        if (!target.exists()) {
            return true;
        }
        if (!target.isDirectory()) {
            return target.delete();
        }
        File[] children = target.listFiles();
        if (children == null) {
            return false;
        }
        if (failIfNotEmpty && children.length > 0) {
            return false;
        }
        for (int i = 0; i < children.length; ++i) {
            if (FileUtil.rmdir(children[i], failIfNotEmpty)) continue;
            return false;
        }
        return target.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractZip(File zipfile, File targetDir) {
        boolean entry2;
        ZipFile zip = null;
        try {
            byte[] buf = new byte[16384];
            zip = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                boolean parentsOk;
                ZipEntry entry2 = entries.nextElement();
                if (entry2.getName().indexOf("..") != -1) {
                    System.err.println("ERROR: Refusing to extract a zip entry with '..' in it [" + entry2.getName() + "]");
                    boolean bl = false;
                    return bl;
                }
                File target = new File(targetDir, entry2.getName());
                File parent = target.getParentFile();
                if (parent != null && !parent.exists() && !(parentsOk = parent.mkdirs())) {
                    System.err.println("ERROR: Unable to create the parent dir for " + entry2.getName() + ": [" + parent.getAbsolutePath() + "]");
                    boolean bl = false;
                    return bl;
                }
                if (entry2.isDirectory()) {
                    if (!target.exists()) {
                        boolean created = target.mkdirs();
                        if (!created) {
                            System.err.println("ERROR: Unable to create the directory [" + entry2.getName() + "]");
                            boolean bl = false;
                            return bl;
                        }
                        System.err.println("INFO: Creating directory [" + entry2.getName() + "]");
                    }
                    continue;
                }
                try {
                    OutputStream fos;
                    InputStream in = zip.getInputStream(entry2);
                    if (entry2.getName().endsWith(".jar.pack") || entry2.getName().endsWith(".war.pack")) {
                        target = new File(targetDir, entry2.getName().substring(0, entry2.getName().length() - ".pack".length()));
                        fos = new JarOutputStream(new FileOutputStream(target));
                        Pack200.newUnpacker().unpack(in, (JarOutputStream)fos);
                        ((ZipOutputStream)fos).close();
                        System.err.println("INFO: File [" + entry2.getName() + "] extracted and unpacked");
                    } else {
                        fos = new FileOutputStream(target);
                        int read = 0;
                        while ((read = in.read(buf)) != -1) {
                            ((FileOutputStream)fos).write(buf, 0, read);
                        }
                        ((FileOutputStream)fos).close();
                        System.err.println("INFO: File [" + entry2.getName() + "] extracted");
                    }
                    in.close();
                }
                catch (IOException ioe) {
                    System.err.println("ERROR: Error extracting the zip entry (" + entry2.getName() + "]");
                    ioe.printStackTrace();
                    boolean bl = false;
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            entry2 = true;
        }
        catch (IOException ioe) {
            System.err.println("ERROR: Unable to extract the zip file");
            ioe.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ioe) {}
            }
        }
        return entry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyZip(File zipfile) {
        boolean entry2;
        ZipFile zip = null;
        try {
            byte[] buf = new byte[16384];
            zip = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry2 = entries.nextElement();
                if (entry2.getName().indexOf("..") != -1) {
                    boolean bl = false;
                    return bl;
                }
                if (entry2.isDirectory()) continue;
                try {
                    InputStream in = zip.getInputStream(entry2);
                    int read = 0;
                    while ((read = in.read(buf)) != -1) {
                    }
                    in.close();
                }
                catch (IOException ioe) {
                    boolean bl = false;
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            entry2 = true;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ioe) {}
            }
        }
        return entry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(String filename, int maxNumLines, boolean startAtBeginning) {
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            ArrayList<String> lines = new ArrayList<String>(maxNumLines > 0 ? maxNumLines : 64);
            String line = null;
            while ((line = in.readLine()) != null) {
                lines.add(line);
                if (maxNumLines <= 0 || lines.size() < maxNumLines) continue;
                if (startAtBeginning) break;
                lines.remove(0);
            }
            StringBuilder buf = new StringBuilder(lines.size() * 80);
            for (int i = 0; i < lines.size(); ++i) {
                buf.append((String)lines.get(i)).append('\n');
            }
            String string = buf.toString();
            return string;
        }
        catch (IOException ioe) {
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(String path, String root, OutputStream out) throws IOException {
        String rootDirStr;
        File rootDir = new File(root);
        while (path.startsWith("/") && path.length() > 0) {
            path = path.substring(1);
        }
        if (path.length() <= 0) {
            throw new FileNotFoundException("Not serving up the root dir");
        }
        File target = new File(rootDir, path);
        if (!target.exists()) {
            throw new FileNotFoundException("Requested file does not exist: " + path);
        }
        String targetStr = target.getCanonicalPath();
        if (!targetStr.startsWith(rootDirStr = rootDir.getCanonicalPath())) {
            throw new FileNotFoundException("Requested file is outside the root dir: " + path);
        }
        byte[] buf = new byte[1024];
        FileInputStream in = null;
        try {
            in = new FileInputStream(target);
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            out.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static boolean copy(String source, String dest, boolean overwriteExisting) {
        return FileUtil.copy(source, dest, overwriteExisting, false);
    }

    public static boolean copy(String source, String dest, boolean overwriteExisting, boolean quiet) {
        File src = new File(source);
        File dst = new File(dest);
        if (dst.exists() && dst.isDirectory()) {
            dst = new File(dst, src.getName());
        }
        if (!src.exists()) {
            return false;
        }
        if (dst.exists() && !overwriteExisting) {
            return false;
        }
        byte[] buf = new byte[4096];
        try {
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            int read = 0;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            in.close();
            out.close();
            return true;
        }
        catch (IOException ioe) {
            if (!quiet) {
                ioe.printStackTrace();
            }
            return false;
        }
    }

    public static void main(String[] args) {
        boolean copied;
        if (args == null || args.length < 2) {
            FileUtil.testRmdir();
        } else if ("delete".equals(args[0])) {
            boolean deleted = FileUtil.rmdir(args[1], false);
            if (!deleted) {
                System.err.println("Error deleting [" + args[1] + "]");
            }
        } else if ("copy".equals(args[0]) && !(copied = FileUtil.copy(args[1], args[2], false))) {
            System.err.println("Error copying [" + args[1] + "] to [" + args[2] + "]");
        }
    }

    private static void testRmdir() {
        File t = new File("rmdirTest/test/subdir/blah");
        boolean created = t.mkdirs();
        if (!t.exists()) {
            throw new RuntimeException("Unable to create test");
        }
        boolean deleted = FileUtil.rmdir("rmdirTest", false);
        if (!deleted) {
            System.err.println("FAIL: unable to delete rmdirTest");
        } else {
            System.out.println("PASS: rmdirTest deleted");
        }
    }
}

