/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.time;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.time.NtpClient;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class Timestamper
implements Runnable {
    private I2PAppContext _context;
    private Log _log;
    private final List<String> _servers = new ArrayList<String>(3);
    private List<String> _priorityServers;
    private final List<UpdateListener> _listeners = new ArrayList<UpdateListener>(1);
    private int _queryFrequency;
    private int _concurringServers;
    private int _consecutiveFails;
    private volatile boolean _disabled;
    private boolean _daemon;
    private boolean _initialized;
    private boolean _wellSynced;
    private static final int MIN_QUERY_FREQUENCY = 300000;
    private static final int DEFAULT_QUERY_FREQUENCY = 300000;
    private static final String DEFAULT_SERVER_LIST = "0.pool.ntp.org,1.pool.ntp.org,2.pool.ntp.org";
    private static final String DEFAULT_DISABLED = "true";
    private static final int DEFAULT_CONCURRING_SERVERS = 3;
    private static final int MAX_CONSECUTIVE_FAILS = 10;
    public static final String PROP_QUERY_FREQUENCY = "time.queryFrequencyMs";
    public static final String PROP_SERVER_LIST = "time.sntpServerList";
    public static final String PROP_DISABLED = "time.disabled";
    public static final String PROP_CONCURRING_SERVERS = "time.concurringServers";
    public static final String PROP_IP_COUNTRY = "i2np.lastCountry";
    private static final int MAX_VARIANCE = 10000;

    public Timestamper(I2PAppContext ctx) {
        this(ctx, null, true);
    }

    public Timestamper(I2PAppContext ctx, UpdateListener lsnr) {
        this(ctx, lsnr, true);
    }

    public Timestamper(I2PAppContext ctx, UpdateListener lsnr, boolean daemon) {
        String disabled = ctx.getProperty(PROP_DISABLED, DEFAULT_DISABLED);
        if (Boolean.valueOf(disabled).booleanValue()) {
            this._initialized = true;
            return;
        }
        this._context = ctx;
        this._daemon = daemon;
        this._initialized = false;
        this._wellSynced = false;
        if (lsnr != null) {
            this._listeners.add(lsnr);
        }
        this.updateConfig();
        this.startTimestamper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getServerCount() {
        List<String> list = this._servers;
        synchronized (list) {
            return this._servers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServer(int index) {
        List<String> list = this._servers;
        synchronized (list) {
            return this._servers.get(index);
        }
    }

    public int getQueryFrequencyMs() {
        return this._queryFrequency;
    }

    public boolean getIsDisabled() {
        return this._disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UpdateListener lsnr) {
        List<UpdateListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UpdateListener lsnr) {
        List<UpdateListener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(lsnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenerCount() {
        List<UpdateListener> list = this._listeners;
        synchronized (list) {
            return this._listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateListener getListener(int index) {
        List<UpdateListener> list = this._listeners;
        synchronized (list) {
            return this._listeners.get(index);
        }
    }

    private void startTimestamper() {
        I2PThread t = new I2PThread(this, "Timestamper");
        t.setPriority(1);
        t.setDaemon(this._daemon);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitialization() {
        try {
            Timestamper timestamper = this;
            synchronized (timestamper) {
                if (!this._initialized) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this._log = this._context.logManager().getLog(Timestamper.class);
        if (this._log.shouldLog(20)) {
            this._log.info("Starting timestamper");
        }
        boolean lastFailed = false;
        block16: while (true) {
            try {
                while (true) {
                    long sleepTime;
                    this.updateConfig();
                    if (!this._disabled) {
                        if (this._priorityServers != null) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("Querying servers " + this._priorityServers);
                            }
                            try {
                                lastFailed = !this.queryTime(this._priorityServers.toArray(new String[this._priorityServers.size()]));
                            }
                            catch (IllegalArgumentException iae) {
                                if (!lastFailed && this._log.shouldLog(30)) {
                                    this._log.warn("Unable to reach country-specific NTP servers");
                                }
                                lastFailed = true;
                            }
                        }
                        if (this._priorityServers == null || lastFailed) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("Querying servers " + this._servers);
                            }
                            try {
                                lastFailed = !this.queryTime(this._servers.toArray(new String[this._servers.size()]));
                            }
                            catch (IllegalArgumentException iae) {
                                if (!this._initialized && this._log.shouldLog(40)) {
                                    ArrayList<String> all = new ArrayList<String>();
                                    if (this._priorityServers != null) {
                                        all.addAll(this._priorityServers);
                                    }
                                    all.addAll(this._servers);
                                    this._log.error("Unable to reach any of the NTP servers " + all + " - network disconnected? Or set time.sntpServerList=myserver1.com,myserver2.com in advanced configuration.");
                                }
                                lastFailed = true;
                            }
                        }
                    }
                    this._initialized = true;
                    Timestamper iae = this;
                    synchronized (iae) {
                        this.notifyAll();
                    }
                    if (lastFailed) {
                        sleepTime = ++this._consecutiveFails >= 10 ? 1800000L : 30000L;
                    } else {
                        this._consecutiveFails = 0;
                        sleepTime = this._context.random().nextInt(this._queryFrequency) + this._queryFrequency;
                        if (this._wellSynced) {
                            sleepTime *= 3L;
                        }
                    }
                    try {
                        Thread.sleep(sleepTime);
                        continue block16;
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                this._log.log(50, "Timestamper died!", t);
                Timestamper timestamper = this;
                synchronized (timestamper) {
                    this.notifyAll();
                }
                return;
            }
        }
    }

    private boolean queryTime(String[] serverList) throws IllegalArgumentException {
        long[] found = new long[this._concurringServers];
        long now = -1L;
        int stratum = -1;
        long expectedDelta = 0L;
        this._wellSynced = false;
        for (int i = 0; i < this._concurringServers; ++i) {
            long delta;
            if (i > 0) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            long[] timeAndStratum = NtpClient.currentTimeAndStratum(serverList);
            now = timeAndStratum[0];
            stratum = (int)timeAndStratum[1];
            found[i] = delta = now - this._context.clock().now();
            if (i == 0) {
                if (Math.abs(delta) < 10000L) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("a single SNTP query was within the tolerance (" + delta + "ms)");
                    }
                    this._wellSynced = Math.abs(delta) < 500L;
                    break;
                }
                expectedDelta = delta;
                continue;
            }
            if (Math.abs(delta - expectedDelta) <= 10000L) continue;
            if (this._log.shouldLog(40)) {
                StringBuilder err = new StringBuilder(96);
                err.append("SNTP client variance exceeded at query ").append(i);
                err.append(".  expected = ");
                err.append(expectedDelta);
                err.append(", found = ");
                err.append(delta);
                err.append(" all deltas: ");
                for (int j = 0; j < found.length; ++j) {
                    err.append(found[j]).append(' ');
                }
                this._log.error(err.toString());
            }
            return false;
        }
        this.stampTime(now, stratum);
        if (this._log.shouldLog(10)) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Deltas: ");
            for (int i = 0; i < found.length; ++i) {
                buf.append(found[i]).append(' ');
            }
            this._log.debug(buf.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stampTime(long now, int stratum) {
        long before = this._context.clock().now();
        List<UpdateListener> list = this._listeners;
        synchronized (list) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                UpdateListener lsnr = this._listeners.get(i);
                lsnr.setNow(now, stratum);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Stamped the time as " + now + " (delta=" + (now - before) + ")");
        }
    }

    private void updateConfig() {
        String serverList = this._context.getProperty(PROP_SERVER_LIST);
        if (serverList == null || serverList.trim().length() <= 0) {
            serverList = DEFAULT_SERVER_LIST;
            String country = this._context.getProperty(PROP_IP_COUNTRY);
            if (country == null && (country = Locale.getDefault().getCountry()) != null) {
                country = country.toLowerCase();
            }
            if (country != null && country.length() > 0) {
                this._priorityServers = new ArrayList<String>(3);
                for (int i = 0; i < 3; ++i) {
                    this._priorityServers.add(i + "." + country + ".pool.ntp.org");
                }
            } else {
                this._priorityServers = null;
            }
        } else {
            this._priorityServers = null;
        }
        this._servers.clear();
        StringTokenizer tok = new StringTokenizer(serverList, ", ");
        while (tok.hasMoreTokens()) {
            String val = tok.nextToken();
            if ((val = val.trim()).length() <= 0) continue;
            this._servers.add(val);
        }
        this._queryFrequency = Math.max(300000, this._context.getProperty(PROP_QUERY_FREQUENCY, 300000));
        String disabled = this._context.getProperty(PROP_DISABLED, DEFAULT_DISABLED);
        this._disabled = Boolean.valueOf(disabled);
        this._concurringServers = Math.min(4, Math.max(1, this._context.getProperty(PROP_CONCURRING_SERVERS, 3)));
    }

    public static void main(String[] args) {
        System.setProperty(PROP_DISABLED, "false");
        System.setProperty(PROP_QUERY_FREQUENCY, "30000");
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        long now = ctx.clock().now();
        for (int i = 0; i < 300000; i += 61000) {
            try {
                Thread.sleep(61000L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    public static interface UpdateListener {
        public void setNow(long var1, int var3);
    }
}

