/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import net.i2p.stat.PersistenceHelper;
import net.i2p.stat.RateStat;
import net.i2p.stat.RateSummaryListener;
import net.i2p.util.Log;

public class Rate {
    private static final Log _log = new Log(Rate.class);
    private volatile double _currentTotalValue;
    private volatile long _currentEventCount;
    private volatile long _currentTotalEventTime;
    private volatile double _lastTotalValue;
    private volatile long _lastEventCount;
    private volatile long _lastTotalEventTime;
    private volatile double _extremeTotalValue;
    private volatile long _extremeEventCount;
    private volatile long _extremeTotalEventTime;
    private volatile double _lifetimeTotalValue;
    private volatile long _lifetimeEventCount;
    private volatile long _lifetimeTotalEventTime;
    private RateSummaryListener _summaryListener;
    private RateStat _stat;
    private volatile long _lastCoalesceDate;
    private long _creationDate;
    private long _period;
    private final Object _lock = new Object();
    private static final int SLACK = 2000;

    public double getCurrentTotalValue() {
        return this._currentTotalValue;
    }

    public long getCurrentEventCount() {
        return this._currentEventCount;
    }

    public long getCurrentTotalEventTime() {
        return this._currentTotalEventTime;
    }

    public double getLastTotalValue() {
        return this._lastTotalValue;
    }

    public long getLastEventCount() {
        return this._lastEventCount;
    }

    public long getLastTotalEventTime() {
        return this._lastTotalEventTime;
    }

    public double getExtremeTotalValue() {
        return this._extremeTotalValue;
    }

    public long getExtremeEventCount() {
        return this._extremeEventCount;
    }

    public long getExtremeTotalEventTime() {
        return this._extremeTotalEventTime;
    }

    public double getLifetimeTotalValue() {
        return this._lifetimeTotalValue;
    }

    public long getLifetimeEventCount() {
        return this._lifetimeEventCount;
    }

    public long getLifetimeTotalEventTime() {
        return this._lifetimeTotalEventTime;
    }

    public long getLastCoalesceDate() {
        return this._lastCoalesceDate;
    }

    public long getCreationDate() {
        return this._creationDate;
    }

    public long getPeriod() {
        return this._period;
    }

    public RateStat getRateStat() {
        return this._stat;
    }

    public void setRateStat(RateStat rs) {
        this._stat = rs;
    }

    public Rate(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("The period must be strictly positive");
        }
        this._currentTotalValue = 0.0;
        this._currentEventCount = 0L;
        this._currentTotalEventTime = 0L;
        this._lastTotalValue = 0.0;
        this._lastEventCount = 0L;
        this._lastTotalEventTime = 0L;
        this._extremeTotalValue = 0.0;
        this._extremeEventCount = 0L;
        this._extremeTotalEventTime = 0L;
        this._lifetimeTotalValue = 0.0;
        this._lifetimeEventCount = 0L;
        this._lifetimeTotalEventTime = 0L;
        this._lastCoalesceDate = this._creationDate = Rate.now();
        this._period = period;
    }

    public Rate(Properties props, String prefix, boolean treatAsCurrent) throws IllegalArgumentException {
        this(1L);
        this.load(props, prefix, treatAsCurrent);
    }

    public void addData(long value) {
        this.addData(value, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(long value, long eventDuration) {
        Object object = this._lock;
        synchronized (object) {
            this._currentTotalValue += (double)value;
            ++this._currentEventCount;
            this._currentTotalEventTime += eventDuration;
            this._lifetimeTotalValue += (double)value;
            ++this._lifetimeEventCount;
            this._lifetimeTotalEventTime += eventDuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coalesce() {
        double correctedTotalValue;
        long now = Rate.now();
        Object object = this._lock;
        synchronized (object) {
            long measuredPeriod = now - this._lastCoalesceDate;
            if (measuredPeriod < this._period - 2000L) {
                if (_log.shouldLog(10)) {
                    _log.debug("not coalescing, measuredPeriod = " + measuredPeriod + " period = " + this._period);
                }
                return;
            }
            double periodFactor = (double)measuredPeriod / (double)this._period;
            this._lastTotalValue = this._currentTotalValue / periodFactor;
            this._lastEventCount = (long)(0.499999 + (double)this._currentEventCount / periodFactor);
            this._lastTotalEventTime = (long)((double)this._currentTotalEventTime / periodFactor);
            this._lastCoalesceDate = now;
            correctedTotalValue = this._currentEventCount == 0L ? 0.0 : this._currentTotalValue * ((double)this._lastEventCount / (double)this._currentEventCount);
            if (this._lastTotalValue > this._extremeTotalValue) {
                this._extremeTotalValue = this._lastTotalValue;
                this._extremeEventCount = this._lastEventCount;
                this._extremeTotalEventTime = this._lastTotalEventTime;
            }
            this._currentTotalValue = 0.0;
            this._currentEventCount = 0L;
            this._currentTotalEventTime = 0L;
        }
        if (this._summaryListener != null) {
            this._summaryListener.add(correctedTotalValue, this._lastEventCount, this._lastTotalEventTime, this._period);
        }
    }

    public void setSummaryListener(RateSummaryListener listener) {
        this._summaryListener = listener;
    }

    public RateSummaryListener getSummaryListener() {
        return this._summaryListener;
    }

    public double getAverageValue() {
        if (this._lastTotalValue != 0.0 && this._lastEventCount > 0L) {
            return this._lastTotalValue / (double)this._lastEventCount;
        }
        return 0.0;
    }

    public double getExtremeAverageValue() {
        if (this._extremeTotalValue != 0.0 && this._extremeEventCount > 0L) {
            return this._extremeTotalValue / (double)this._extremeEventCount;
        }
        return 0.0;
    }

    public double getLifetimeAverageValue() {
        if (this._lifetimeTotalValue != 0.0 && this._lifetimeEventCount > 0L) {
            return this._lifetimeTotalValue / (double)this._lifetimeEventCount;
        }
        return 0.0;
    }

    public double getLastEventSaturation() {
        if (this._lastEventCount > 0L && this._lastTotalEventTime > 0L) {
            return (double)this._lastTotalEventTime / (double)this._period;
        }
        return 0.0;
    }

    public double getExtremeEventSaturation() {
        if (this._extremeEventCount > 0L && this._extremeTotalEventTime > 0L) {
            double eventTime = (double)this._extremeTotalEventTime / (double)this._extremeEventCount;
            double maxEvents = (double)this._period / eventTime;
            return (double)this._extremeEventCount / maxEvents;
        }
        return 0.0;
    }

    public double getLifetimeEventSaturation() {
        if (this._lastEventCount > 0L && this._lifetimeTotalEventTime > 0L) {
            double eventTime = (double)this._lifetimeTotalEventTime / (double)this._lifetimeEventCount;
            double maxEvents = (double)this._period / eventTime;
            double numPeriods = this.getLifetimePeriods();
            double avgEventsPerPeriod = (double)this._lifetimeEventCount / numPeriods;
            return avgEventsPerPeriod / maxEvents;
        }
        return 0.0;
    }

    public long getLifetimePeriods() {
        long lifetime = Rate.now() - this._creationDate;
        double periods = (double)lifetime / (double)this._period;
        return (long)Math.floor(periods);
    }

    public double getLastSaturationLimit() {
        if (this._lastTotalValue != 0.0 && this._lastEventCount > 0L && this._lastTotalEventTime > 0L) {
            double saturation = this.getLastEventSaturation();
            if (saturation != 0.0) {
                return this._lastTotalValue / saturation;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getExtremeSaturationLimit() {
        if (this._extremeTotalValue != 0.0 && this._extremeEventCount > 0L && this._extremeTotalEventTime > 0L) {
            double saturation = this.getExtremeEventSaturation();
            if (saturation != 0.0) {
                return this._extremeTotalValue / saturation;
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getPercentageOfExtremeValue() {
        if (this._lastTotalValue != 0.0 && this._extremeTotalValue != 0.0) {
            return this._lastTotalValue / this._extremeTotalValue;
        }
        return 0.0;
    }

    public double getPercentageOfLifetimeValue() {
        if (this._lastTotalValue != 0.0 && this._lifetimeTotalValue != 0.0) {
            double lifetimePeriodValue = (double)this._period * (this._lifetimeTotalValue / (double)(Rate.now() - this._creationDate));
            return this._lastTotalValue / lifetimePeriodValue;
        }
        return 0.0;
    }

    public void store(String prefix, StringBuilder buf) throws IOException {
        PersistenceHelper.add(buf, prefix, ".period", "Number of milliseconds in the period", this._period);
        PersistenceHelper.add(buf, prefix, ".creationDate", "When was this rate created?  (milliseconds since the epoch, GMT)", this._creationDate);
        PersistenceHelper.add(buf, prefix, ".lastCoalesceDate", "When did we last coalesce this rate?  (milliseconds since the epoch, GMT)", this._lastCoalesceDate);
        PersistenceHelper.add(buf, prefix, ".currentDate", "When did this data get written?  (milliseconds since the epoch, GMT)", Rate.now());
        PersistenceHelper.add(buf, prefix, ".currentTotalValue", "Total value of data points in the current (uncoalesced) period", this._currentTotalValue);
        PersistenceHelper.add(buf, prefix, ".currentEventCount", "How many events have occurred in the current (uncoalesced) period?", this._currentEventCount);
        PersistenceHelper.add(buf, prefix, ".currentTotalEventTime", "How many milliseconds have the events in the current (uncoalesced) period consumed?", this._currentTotalEventTime);
        PersistenceHelper.add(buf, prefix, ".lastTotalValue", "Total value of data points in the most recent (coalesced) period", this._lastTotalValue);
        PersistenceHelper.add(buf, prefix, ".lastEventCount", "How many events have occurred in the most recent (coalesced) period?", this._lastEventCount);
        PersistenceHelper.add(buf, prefix, ".lastTotalEventTime", "How many milliseconds have the events in the most recent (coalesced) period consumed?", this._lastTotalEventTime);
        PersistenceHelper.add(buf, prefix, ".extremeTotalValue", "Total value of data points in the most extreme period", this._extremeTotalValue);
        PersistenceHelper.add(buf, prefix, ".extremeEventCount", "How many events have occurred in the most extreme period?", this._extremeEventCount);
        PersistenceHelper.add(buf, prefix, ".extremeTotalEventTime", "How many milliseconds have the events in the most extreme period consumed?", this._extremeTotalEventTime);
        PersistenceHelper.add(buf, prefix, ".lifetimeTotalValue", "Total value of data points since this stat was created", this._lifetimeTotalValue);
        PersistenceHelper.add(buf, prefix, ".lifetimeEventCount", "How many events have occurred since this stat was created?", this._lifetimeEventCount);
        PersistenceHelper.add(buf, prefix, ".lifetimeTotalEventTime", "How many milliseconds have the events since this stat was created consumed?", this._lifetimeTotalEventTime);
    }

    public void load(Properties props, String prefix, boolean treatAsCurrent) throws IllegalArgumentException {
        this._period = PersistenceHelper.getLong(props, prefix, ".period");
        this._creationDate = PersistenceHelper.getLong(props, prefix, ".creationDate");
        this._lastCoalesceDate = PersistenceHelper.getLong(props, prefix, ".lastCoalesceDate");
        this._currentTotalValue = PersistenceHelper.getDouble(props, prefix, ".currentTotalValue");
        this._currentEventCount = PersistenceHelper.getLong(props, prefix, ".currentEventCount");
        this._currentTotalEventTime = PersistenceHelper.getLong(props, prefix, ".currentTotalEventTime");
        this._lastTotalValue = PersistenceHelper.getDouble(props, prefix, ".lastTotalValue");
        this._lastEventCount = PersistenceHelper.getLong(props, prefix, ".lastEventCount");
        this._lastTotalEventTime = PersistenceHelper.getLong(props, prefix, ".lastTotalEventTime");
        this._extremeTotalValue = PersistenceHelper.getDouble(props, prefix, ".extremeTotalValue");
        this._extremeEventCount = PersistenceHelper.getLong(props, prefix, ".extremeEventCount");
        this._extremeTotalEventTime = PersistenceHelper.getLong(props, prefix, ".extremeTotalEventTime");
        this._lifetimeTotalValue = PersistenceHelper.getDouble(props, prefix, ".lifetimeTotalValue");
        this._lifetimeEventCount = PersistenceHelper.getLong(props, prefix, ".lifetimeEventCount");
        this._lifetimeTotalEventTime = PersistenceHelper.getLong(props, prefix, ".lifetimeTotalEventTime");
        if (treatAsCurrent) {
            this._lastCoalesceDate = Rate.now();
        }
        if (this._period <= 0L) {
            throw new IllegalArgumentException("Period for " + prefix + " is invalid");
        }
        this.coalesce();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != Rate.class) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Rate r = (Rate)obj;
        return this._period == r.getPeriod() && this._creationDate == r.getCreationDate() && this._currentTotalValue == r.getCurrentTotalValue() && this._currentEventCount == r.getCurrentEventCount() && this._currentTotalEventTime == r.getCurrentTotalEventTime() && this._lastTotalValue == r.getLastTotalValue() && this._lastEventCount == r.getLastEventCount() && this._lastTotalEventTime == r.getLastTotalEventTime() && this._extremeTotalValue == r.getExtremeTotalValue() && this._extremeEventCount == r.getExtremeEventCount() && this._extremeTotalEventTime == r.getExtremeTotalEventTime() && this._lifetimeTotalValue == r.getLifetimeTotalValue() && this._lifetimeEventCount == r.getLifetimeEventCount() && this._lifetimeTotalEventTime == r.getLifetimeTotalEventTime();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(2048);
        buf.append("\n\t total value: ").append(this.getLastTotalValue());
        buf.append("\n\t highest total value: ").append(this.getExtremeTotalValue());
        buf.append("\n\t lifetime total value: ").append(this.getLifetimeTotalValue());
        buf.append("\n\t # periods: ").append(this.getLifetimePeriods());
        buf.append("\n\t average value: ").append(this.getAverageValue());
        buf.append("\n\t highest average value: ").append(this.getExtremeAverageValue());
        buf.append("\n\t lifetime average value: ").append(this.getLifetimeAverageValue());
        buf.append("\n\t % of lifetime rate: ").append(100.0 * this.getPercentageOfLifetimeValue());
        buf.append("\n\t % of highest rate: ").append(100.0 * this.getPercentageOfExtremeValue());
        buf.append("\n\t # events: ").append(this.getLastEventCount());
        buf.append("\n\t lifetime events: ").append(this.getLifetimeEventCount());
        if (this.getLifetimeTotalEventTime() > 0L) {
            buf.append("\n\t % of time spent processing events: ").append(100.0 * this.getLastEventSaturation());
            buf.append("\n\t total value if we were always processing events: ").append(this.getLastSaturationLimit());
            buf.append("\n\t max % of time spent processing events: ").append(100.0 * this.getExtremeEventSaturation());
            buf.append("\n\t max total value if we were always processing events: ").append(this.getExtremeSaturationLimit());
        }
        return buf.toString();
    }

    private static final long now() {
        return System.currentTimeMillis();
    }

    public static void main(String[] args) {
        Rate rate = new Rate(1000L);
        for (int i = 0; i < 50; ++i) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            rate.addData(i * 100, 20L);
        }
        rate.coalesce();
        StringBuilder buf = new StringBuilder(1024);
        try {
            rate.store("rate.test", buf);
            byte[] data = buf.toString().getBytes();
            _log.error("Stored rate: size = " + data.length + "\n" + buf.toString());
            Properties props = new Properties();
            props.load(new ByteArrayInputStream(data));
            Rate r = new Rate(props, "rate.test", true);
            _log.error("Comparison after store/load: " + r.equals(rate));
        }
        catch (Throwable t) {
            _log.error("b0rk", t);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

