/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.util.Clock;

public class SetDateMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 33;
    private Date _date;

    public SetDateMessage() {
        this.setDate(new Date(Clock.getInstance().now()));
    }

    public Date getDate() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._date = DataHelper.readDate(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._date == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        try {
            DataHelper.writeDate(os, this._date);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 33;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SetDateMessage) {
            SetDateMessage msg = (SetDateMessage)object;
            return DataHelper.eq(this.getDate(), msg.getDate());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[SetDateMessage");
        buf.append("\n\tDate: ").append(this.getDate());
        buf.append("]");
        return buf.toString();
    }
}

