/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.util.Log;

public class Payload
extends DataStructureImpl {
    private static final Log _log = new Log(Payload.class);
    private byte[] _encryptedData;
    private byte[] _unencryptedData;

    public Payload() {
        this.setUnencryptedData(null);
        this.setEncryptedData(null);
    }

    public byte[] getUnencryptedData() {
        return this._unencryptedData;
    }

    public void setUnencryptedData(byte[] data) {
        this._unencryptedData = data;
    }

    public byte[] getEncryptedData() {
        return this._encryptedData;
    }

    public void setEncryptedData(byte[] data) {
        this._encryptedData = data;
    }

    public int getSize() {
        if (this._unencryptedData != null) {
            return this._unencryptedData.length;
        }
        if (this._encryptedData != null) {
            return this._encryptedData.length;
        }
        return 0;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        int size = (int)DataHelper.readLong(in, 4);
        if (size < 0) {
            throw new DataFormatException("payload size out of range (" + size + ")");
        }
        this._encryptedData = new byte[size];
        int read = this.read(in, this._encryptedData);
        if (read != size) {
            throw new DataFormatException("Incorrect number of bytes read in the payload structure");
        }
        if (_log.shouldLog(10)) {
            _log.debug("read payload: " + read + " bytes");
        }
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._encryptedData == null) {
            throw new DataFormatException("Not yet encrypted.  Please set the encrypted data");
        }
        DataHelper.writeLong(out, 4, this._encryptedData.length);
        out.write(this._encryptedData);
        if (_log.shouldLog(10)) {
            _log.debug("wrote payload: " + this._encryptedData.length);
        }
    }

    public int writeBytes(byte[] target, int offset) {
        if (this._encryptedData == null) {
            throw new IllegalStateException("Not yet encrypted.  Please set the encrypted data");
        }
        DataHelper.toLong(target, offset, 4, this._encryptedData.length);
        System.arraycopy(this._encryptedData, 0, target, offset += 4, this._encryptedData.length);
        return 4 + this._encryptedData.length;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Payload)) {
            return false;
        }
        Payload p = (Payload)object;
        return DataHelper.eq(this._unencryptedData, p.getUnencryptedData()) && DataHelper.eq(this._encryptedData, p.getEncryptedData());
    }

    public int hashCode() {
        return DataHelper.hashCode(this._unencryptedData);
    }

    public String toString() {
        return "[Payload]";
    }
}

