/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.util.Log;

public class Hash
extends DataStructureImpl {
    private static final Log _log = new Log(Hash.class);
    private byte[] _data;
    private volatile String _stringified;
    private volatile String _base64ed;
    private Map _xorCache;
    private int _cachedHashCode;
    public static final int HASH_LENGTH = 32;
    public static final Hash FAKE_HASH = new Hash(new byte[32]);
    private static final int MAX_CACHED_XOR = 1024;

    public Hash() {
        this.setData(null);
    }

    public Hash(byte[] data) {
        this.setData(data);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
        this._stringified = null;
        this._base64ed = null;
        this._cachedHashCode = this.calcHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCache() {
        Hash hash = this;
        synchronized (hash) {
            if (this._xorCache == null) {
                this._xorCache = new HashMap(1024);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] cachedXor(Hash key) throws IllegalStateException {
        if (this._xorCache == null) {
            throw new IllegalStateException("To use the cache, you must first prepare it");
        }
        byte[] distance = (byte[])this._xorCache.get(key);
        if (distance == null) {
            int cached = 0;
            Map map = this._xorCache;
            synchronized (map) {
                int toRemove = this._xorCache.size() + 1 - 1024;
                if (toRemove > 0) {
                    HashSet<Object> keys = new HashSet<Object>(toRemove);
                    Iterator<Object> iter = this._xorCache.keySet().iterator();
                    for (int removed = 0; iter.hasNext() && removed < toRemove; ++removed) {
                        keys.add(iter.next());
                    }
                    iter = keys.iterator();
                    while (iter.hasNext()) {
                        this._xorCache.remove(iter.next());
                    }
                }
                distance = DataHelper.xor(key.getData(), this.getData());
                this._xorCache.put(key, distance);
                cached = this._xorCache.size();
            }
            if (_log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("miss [").append(cached).append("] from ");
                buf.append(DataHelper.toHexString(this.getData())).append(" to ");
                buf.append(DataHelper.toHexString(key.getData()));
                _log.debug(buf.toString(), new Exception());
            }
        } else if (_log.shouldLog(10)) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("hit from ");
            buf.append(DataHelper.toHexString(this.getData())).append(" to ");
            buf.append(DataHelper.toHexString(key.getData()));
            _log.debug(buf.toString());
        }
        return distance;
    }

    public void clearXorCache() {
        this._xorCache = null;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._data = new byte[32];
        this._stringified = null;
        this._base64ed = null;
        int read = this.read(in, this._data);
        if (read != 32) {
            throw new DataFormatException("Not enough bytes to read the hash");
        }
        this._cachedHashCode = this.calcHashCode();
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._data == null) {
            throw new DataFormatException("No data in the hash to write out");
        }
        if (this._data.length != 32) {
            throw new DataFormatException("Invalid size of data in the hash");
        }
        out.write(this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Hash)) {
            return false;
        }
        return DataHelper.eq(this._data, ((Hash)obj)._data);
    }

    public int hashCode() {
        return this._cachedHashCode;
    }

    private int calcHashCode() {
        int rv = 0;
        if (this._data != null) {
            for (int i = 0; i < 4; ++i) {
                rv ^= this._data[i] << i * 8;
            }
        }
        return rv;
    }

    public String toString() {
        if (this._stringified == null) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("[Hash: ");
            if (this._data == null) {
                buf.append("null hash");
            } else {
                buf.append(this.toBase64());
            }
            buf.append("]");
            this._stringified = buf.toString();
        }
        return this._stringified;
    }

    public String toBase64() {
        if (this._base64ed == null) {
            this._base64ed = super.toBase64();
        }
        return this._base64ed;
    }
}

