/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

public class Base64 {
    private static final Log _log = new Log(Base64.class);
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] ALPHABET_ALT = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 126};
    private static final byte[] DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final byte BAD_ENCODING = -9;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    public static String encode(String source) {
        return source != null ? Base64.encode(source.getBytes()) : "";
    }

    public static String encode(byte[] source) {
        return source != null ? Base64.encode(source, 0, source.length) : "";
    }

    public static String encode(byte[] source, int off, int len) {
        return source != null ? Base64.encode(source, off, len, false) : "";
    }

    public static String encode(byte[] source, boolean useStandardAlphabet) {
        return source != null ? Base64.encode(source, 0, source.length, useStandardAlphabet) : "";
    }

    public static String encode(byte[] source, int off, int len, boolean useStandardAlphabet) {
        return source != null ? Base64.safeEncode(source, off, len, useStandardAlphabet) : "";
    }

    public static byte[] decode(String s) {
        return Base64.safeDecode(s, false);
    }

    private Base64() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Base64.help();
            return;
        }
        Base64.runApp(args);
    }

    private static void runApp(String[] args) {
        try {
            if ("encodestring".equalsIgnoreCase(args[0])) {
                System.out.println(Base64.encode(args[1].getBytes()));
                return;
            }
            InputStream in = System.in;
            OutputStream out = System.out;
            if (args.length >= 3) {
                out = new FileOutputStream(args[2]);
            }
            if (args.length >= 2) {
                in = new FileInputStream(args[1]);
            }
            if ("encode".equalsIgnoreCase(args[0])) {
                Base64.encode(in, out);
                return;
            }
            if ("decode".equalsIgnoreCase(args[0])) {
                Base64.decode(in, out);
                return;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    private static byte[] read(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) >= 0) {
            baos.write(buf, 0, read);
        }
        return baos.toByteArray();
    }

    private static void encode(InputStream in, OutputStream out) throws IOException {
        String encoded = Base64.encode(Base64.read(in));
        for (int i = 0; i < encoded.length(); ++i) {
            out.write((byte)(encoded.charAt(i) & 0xFF));
        }
    }

    private static void decode(InputStream in, OutputStream out) throws IOException {
        byte[] decoded = Base64.decode(new String(Base64.read(in)));
        out.write(decoded);
    }

    private static void help() {
        System.out.println("Syntax: Base64 encode <inFile> <outFile>");
        System.out.println("or    : Base64 encode <inFile>");
        System.out.println("or    : Base64 encode");
        System.out.println("or    : Base64 decode <inFile> <outFile>");
        System.out.println("or    : Base64 decode <inFile>");
        System.out.println("or    : Base64 decode");
        System.out.println("or    : Base64 test");
    }

    private static void test() {
        String orig = "you smell";
        String encoded = Base64.encode(orig.getBytes());
        System.out.println("Encoded: [" + encoded + "]");
        byte[] decoded = Base64.decode(encoded);
        String transformed = new String(decoded);
        if (!orig.equals(transformed)) {
            throw new RuntimeException("D(E('you smell')) != 'you smell'!!! transformed = [" + transformed + "]");
        }
        System.out.println("D(E('you smell')) == 'you smell'");
        byte[] all = new byte[256];
        for (int i = 0; i < all.length; ++i) {
            all[i] = (byte)(0xFF & i);
        }
        encoded = Base64.encode(all);
        System.out.println("Encoded: [" + encoded + "]");
        decoded = Base64.decode(encoded);
        if (!DataHelper.eq(decoded, all)) {
            throw new RuntimeException("D(E([all bytes])) != [all bytes]!!!");
        }
        System.out.println("D(E([all bytes])) == [all bytes]");
    }

    private static byte[] encode3to4(byte[] threeBytes, int numSigBytes) {
        byte[] dest = new byte[4];
        Base64.encode3to4(threeBytes, 0, numSigBytes, dest, 0);
        return dest;
    }

    private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    private static void encode3to4(byte[] source, int srcOffset, int numSigBytes, StringBuilder buf, byte[] alpha) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                buf.append((char)alpha[inBuff >>> 18]);
                buf.append((char)alpha[inBuff >>> 12 & 0x3F]);
                buf.append((char)alpha[inBuff >>> 6 & 0x3F]);
                buf.append((char)alpha[inBuff & 0x3F]);
                return;
            }
            case 2: {
                buf.append((char)alpha[inBuff >>> 18]);
                buf.append((char)alpha[inBuff >>> 12 & 0x3F]);
                buf.append((char)alpha[inBuff >>> 6 & 0x3F]);
                buf.append('=');
                return;
            }
            case 1: {
                buf.append((char)alpha[inBuff >>> 18]);
                buf.append((char)alpha[inBuff >>> 12 & 0x3F]);
                buf.append('=');
                buf.append('=');
                return;
            }
        }
    }

    private static String safeEncode(byte[] source, int off, int len, boolean useStandardAlphabet) {
        if (len + off > source.length) {
            throw new ArrayIndexOutOfBoundsException("Trying to encode too much!  source.len=" + source.length + " off=" + off + " len=" + len);
        }
        StringBuilder buf = new StringBuilder(len * 4 / 3);
        if (useStandardAlphabet) {
            Base64.encodeBytes(source, off, len, false, buf, ALPHABET);
        } else {
            Base64.encodeBytes(source, off, len, false, buf, ALPHABET_ALT);
        }
        return buf.toString();
    }

    private static byte[] safeDecode(String source, boolean useStandardAlphabet) {
        if (source == null) {
            return null;
        }
        String toDecode = null;
        if (useStandardAlphabet) {
            toDecode = source;
        } else {
            toDecode = source.replace('~', '/');
            toDecode = toDecode.replace('-', '+');
        }
        return Base64.standardDecode(toDecode);
    }

    private static String encodeBytes(byte[] source, boolean breakLines) {
        return Base64.encodeBytes(source, 0, source.length, breakLines);
    }

    private static String encodeBytes(byte[] source, int off, int len, boolean breakLines) {
        StringBuilder buf = new StringBuilder(len * 4 / 3);
        Base64.encodeBytes(source, off, len, breakLines, buf, ALPHABET);
        return buf.toString();
    }

    private static void encodeBytes(byte[] source, int off, int len, boolean breakLines, StringBuilder out, byte[] alpha) {
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d < len2) {
            Base64.encode3to4(source, d + off, 3, out, alpha);
            if (breakLines && (lineLength += 4) == 76) {
                out.append('\n');
                ++e;
                lineLength = 0;
            }
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(source, d + off, len - d, out, alpha);
            e += 4;
        }
    }

    private static String encodeString(String s, boolean breakLines) {
        byte[] src = new byte[s.length()];
        for (int i = 0; i < src.length; ++i) {
            src[i] = (byte)(s.charAt(i) & 0xFF);
        }
        return Base64.encodeBytes(src, breakLines);
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        if (source[srcOffset + 2] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        try {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source[srcOffset + 3]] & 0xFF;
            destination[destOffset] = (byte)(outBuff >> 16);
            destination[destOffset + 1] = (byte)(outBuff >> 8);
            destination[destOffset + 2] = (byte)outBuff;
            return 3;
        }
        catch (Exception e) {
            System.out.println("" + source[srcOffset] + ": " + DECODABET[source[srcOffset]]);
            System.out.println("" + source[srcOffset + 1] + ": " + DECODABET[source[srcOffset + 1]]);
            System.out.println("" + source[srcOffset + 2] + ": " + DECODABET[source[srcOffset + 2]]);
            System.out.println("" + source[srcOffset + 3] + ": " + DECODABET[source[srcOffset + 3]]);
            return -1;
        }
    }

    private static byte[] standardDecode(String s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(s.charAt(i) & 0xFF);
        }
        return Base64.decode(bytes, 0, bytes.length);
    }

    public static String decodeToString(String s) {
        return new String(Base64.decode(s));
    }

    private static byte[] decode(byte[] source, int off, int len) {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = 0; i < len; ++i) {
            sbiCrop = (byte)(source[i] & 0x7F);
            sbiDecode = DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            _log.warn("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
            return null;
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }
}

