/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.datagram;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.i2p.client.I2PSession;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataFormatException;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Log;

public final class I2PDatagramMaker {
    private static Log _log = new Log(I2PDatagramMaker.class);
    private static int DGRAM_BUFSIZE = 32768;
    private SHA256Generator hashGen = SHA256Generator.getInstance();
    private DSAEngine dsaEng = DSAEngine.getInstance();
    private SigningPrivateKey sxPrivKey = null;
    private byte[] sxDestBytes = null;
    private ByteArrayOutputStream sxDGram = new ByteArrayOutputStream(DGRAM_BUFSIZE);

    public I2PDatagramMaker(I2PSession session) {
        this.sxPrivKey = session.getPrivateKey();
        this.sxDestBytes = session.getMyDestination().toByteArray();
    }

    public I2PDatagramMaker() {
    }

    public void setI2PDatagramMaker(I2PSession session) {
        this.sxPrivKey = session.getPrivateKey();
        this.sxDestBytes = session.getMyDestination().toByteArray();
    }

    public byte[] makeI2PDatagram(byte[] payload) {
        this.sxDGram.reset();
        try {
            this.sxDGram.write(this.sxDestBytes);
            this.dsaEng.sign(this.hashGen.calculateHash(payload).toByteArray(), this.sxPrivKey).writeBytes(this.sxDGram);
            this.sxDGram.write(payload);
            return this.sxDGram.toByteArray();
        }
        catch (IOException e) {
            _log.error("Caught IOException", e);
            return null;
        }
        catch (DataFormatException e) {
            _log.error("Caught DataFormatException", e);
            return null;
        }
    }
}

