/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.i2cp.AbuseReason;
import net.i2p.data.i2cp.AbuseSeverity;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.CreateSessionMessage;
import net.i2p.data.i2cp.DestroySessionMessage;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.ReconfigureSessionMessage;
import net.i2p.data.i2cp.ReportAbuseMessage;
import net.i2p.data.i2cp.SendMessageExpiresMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.util.Log;

class I2CPMessageProducer {
    private static final Log _log = new Log(I2CPMessageProducer.class);
    private I2PAppContext _context;
    private int _sendBps;
    private long _sendPeriodBytes;
    private long _sendPeriodBeginTime;
    static final boolean END_TO_END_CRYPTO = false;

    public I2CPMessageProducer(I2PAppContext context) {
        this._context = context;
        this._sendBps = 0;
        context.statManager().createRateStat("client.sendBpsRaw", "How fast we pump out I2CP data messages", "ClientMessages", new long[]{60000L, 300000L, 600000L, 3600000L});
    }

    public void connect(I2PSessionImpl session) throws I2PSessionException {
        CreateSessionMessage msg = new CreateSessionMessage();
        SessionConfig cfg = new SessionConfig(session.getMyDestination());
        cfg.setOptions(session.getOptions());
        if (_log.shouldLog(10)) {
            _log.debug("config created");
        }
        try {
            cfg.signSessionConfig(session.getPrivateKey());
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Unable to sign the session config", dfe);
        }
        if (_log.shouldLog(10)) {
            _log.debug("config signed");
        }
        msg.setSessionConfig(cfg);
        if (_log.shouldLog(10)) {
            _log.debug("config loaded into message");
        }
        session.sendMessage(msg);
        if (_log.shouldLog(10)) {
            _log.debug("config message sent");
        }
    }

    public void disconnect(I2PSessionImpl session) throws I2PSessionException {
        if (session.isClosed()) {
            return;
        }
        DestroySessionMessage dmsg = new DestroySessionMessage();
        dmsg.setSessionId(session.getSessionId());
        session.sendMessage(dmsg);
    }

    public void sendMessage(I2PSessionImpl session, Destination dest, long nonce, byte[] payload, SessionTag tag, SessionKey key, Set tags, SessionKey newKey, long expires) throws I2PSessionException {
        SendMessageMessage msg;
        if (expires > 0L) {
            msg = new SendMessageExpiresMessage();
            ((SendMessageExpiresMessage)msg).setExpiration(new Date(expires));
        } else {
            msg = new SendMessageMessage();
        }
        msg.setDestination(dest);
        msg.setSessionId(session.getSessionId());
        msg.setNonce(nonce);
        Payload data = this.createPayload(dest, payload, tag, key, tags, newKey);
        msg.setPayload(data);
        session.sendMessage(msg);
        this.updateBps(payload.length);
    }

    private void updateBps(int len) {
        long now = this._context.clock().now();
        float period = ((float)now - (float)this._sendPeriodBeginTime) / 1000.0f;
        if (period >= 1.0f) {
            this._sendBps = (int)(0.9f * (float)this._sendBps + 0.1f * (float)this._sendPeriodBytes / period);
            this._sendPeriodBytes = len;
            this._sendPeriodBeginTime = now;
            this._context.statManager().addRateData("client.sendBpsRaw", this._sendBps, 0L);
        } else {
            this._sendPeriodBytes += (long)len;
        }
    }

    private Payload createPayload(Destination dest, byte[] payload, SessionTag tag, SessionKey key, Set tags, SessionKey newKey) throws I2PSessionException {
        if (dest == null) {
            throw new I2PSessionException("No destination specified");
        }
        if (payload == null) {
            throw new I2PSessionException("No payload specified");
        }
        Payload data = new Payload();
        data.setEncryptedData(payload);
        return data;
    }

    public void reportAbuse(I2PSessionImpl session, int msgId, int severity) throws I2PSessionException {
        ReportAbuseMessage msg = new ReportAbuseMessage();
        MessageId id = new MessageId();
        id.setMessageId(msgId);
        msg.setMessageId(id);
        AbuseReason reason = new AbuseReason();
        reason.setReason("Not specified");
        msg.setReason(reason);
        AbuseSeverity sv = new AbuseSeverity();
        sv.setSeverity(severity);
        msg.setSeverity(sv);
        session.sendMessage(msg);
    }

    public void createLeaseSet(I2PSessionImpl session, LeaseSet leaseSet, SigningPrivateKey signingPriv, PrivateKey priv) throws I2PSessionException {
        CreateLeaseSetMessage msg = new CreateLeaseSetMessage();
        msg.setLeaseSet(leaseSet);
        msg.setPrivateKey(priv);
        msg.setSigningPrivateKey(signingPriv);
        msg.setSessionId(session.getSessionId());
        session.sendMessage(msg);
    }

    public void updateTunnels(I2PSessionImpl session, int tunnels) throws I2PSessionException {
        ReconfigureSessionMessage msg = new ReconfigureSessionMessage();
        SessionConfig cfg = new SessionConfig(session.getMyDestination());
        Properties props = session.getOptions();
        if (tunnels > 0) {
            Properties newprops = new Properties();
            newprops.putAll((Map<?, ?>)props);
            props = newprops;
            props.setProperty("inbound.quantity", "" + tunnels);
            props.setProperty("outbound.quantity", "" + tunnels);
            props.setProperty("inbound.backupQuantity", "0");
            props.setProperty("outbound.backupQuantity", "0");
        }
        cfg.setOptions(props);
        try {
            cfg.signSessionConfig(session.getPrivateKey());
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Unable to sign the session config", dfe);
        }
        msg.setSessionConfig(cfg);
        msg.setSessionId(session.getSessionId());
        session.sendMessage(msg);
    }
}

