/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.util.I2PAppThread;

class ClientWriterRunner
implements Runnable {
    private OutputStream _out;
    private I2PSessionImpl _session;
    private BlockingQueue<I2CPMessage> _messagesToWrite;
    private static volatile long __Id = 0L;

    public ClientWriterRunner(OutputStream out, I2PSessionImpl session) {
        this._out = out;
        this._session = session;
        this._messagesToWrite = new LinkedBlockingQueue<I2CPMessage>();
        I2PAppThread t = new I2PAppThread(this, "I2CP Client Writer " + ++__Id, true);
        t.start();
    }

    public void addMessage(I2CPMessage msg) {
        try {
            this._messagesToWrite.put(msg);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopWriting() {
        this._messagesToWrite.clear();
        try {
            this._messagesToWrite.put(new PoisonMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this._session.isClosed()) {
            I2CPMessage msg;
            try {
                msg = this._messagesToWrite.take();
            }
            catch (InterruptedException ie) {
                continue;
            }
            if (msg.getType() == 999999) break;
            try {
                msg.writeMessage(this._out);
                this._out.flush();
            }
            catch (I2CPMessageException ime) {
                this._session.propogateError("Error writing out the message", ime);
                this._session.disconnect();
                break;
            }
            catch (IOException ioe) {
                this._session.propogateError("Error writing out the message", ioe);
                this._session.disconnect();
                break;
            }
        }
        this._messagesToWrite.clear();
    }

    private static class PoisonMessage
    extends I2CPMessageImpl {
        public static final int MESSAGE_TYPE = 999999;

        private PoisonMessage() {
        }

        public int getType() {
            return 999999;
        }

        public void doReadMessage(InputStream buf, int size) throws I2CPMessageException, IOException {
        }

        public byte[] doWriteMessage() throws I2CPMessageException, IOException {
            return null;
        }
    }
}

