/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.prng;

import gnu.crypto.prng.FortunaStandalone;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;

public class AsyncFortunaStandalone
extends FortunaStandalone
implements Runnable {
    private static final int DEFAULT_BUFFERS = 2;
    private static final int BUFSIZE = 262144;
    private int _bufferCount;
    private final byte[][] asyncBuffers;
    private final int[] status;
    private int nextBuf = 0;
    private I2PAppContext _context;
    private Log _log;
    private static final int STATUS_NEED_FILL = 0;
    private static final int STATUS_FILLING = 1;
    private static final int STATUS_FILLED = 2;
    private static final int STATUS_LIVE = 3;

    public AsyncFortunaStandalone(I2PAppContext context) {
        this._bufferCount = Math.max(context.getProperty("prng.buffers", 2), 2);
        this.asyncBuffers = new byte[this._bufferCount][262144];
        this.status = new int[this._bufferCount];
        for (int i = 0; i < this._bufferCount; ++i) {
            this.status[i] = 0;
        }
        this._context = context;
        context.statManager().createRateStat("prng.bufferWaitTime", "", "Encryption", new long[]{60000L, 600000L, 3600000L});
        context.statManager().createRateStat("prng.bufferFillTime", "", "Encryption", new long[]{60000L, 600000L, 3600000L});
        this._log = context.logManager().getLog(AsyncFortunaStandalone.class);
    }

    public void startup() {
        Thread refillThread = new Thread((Runnable)this, "PRNG");
        refillThread.setDaemon(true);
        refillThread.setPriority(2);
        refillThread.start();
    }

    public void seed(byte[] val) {
        HashMap<String, byte[]> props = new HashMap<String, byte[]>(1);
        props.put("gnu.crypto.prng.fortuna.seed", val);
        this.init(props);
    }

    protected void allocBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rotateBuffer() {
        byte[][] byArray = this.asyncBuffers;
        synchronized (this.asyncBuffers) {
            long before = System.currentTimeMillis();
            long waited = 0L;
            while (this.status[this.nextBuf] != 2) {
                this.asyncBuffers.notifyAll();
                try {
                    this.asyncBuffers.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                waited = System.currentTimeMillis() - before;
            }
            this._context.statManager().addRateData("prng.bufferWaitTime", waited, 0L);
            if (waited > 10000L && this._log.shouldLog(30)) {
                this._log.warn(Thread.currentThread().getName() + ": Took " + waited + "ms for a full PRNG buffer to be found");
            }
            this.buffer = this.asyncBuffers[this.nextBuf];
            this.status[this.nextBuf] = 3;
            int prev = this.nextBuf - 1;
            if (prev < 0) {
                prev = this._bufferCount - 1;
            }
            if (this.status[prev] == 3) {
                this.status[prev] = 0;
            }
            ++this.nextBuf;
            if (this.nextBuf >= this._bufferCount) {
                this.nextBuf = 0;
            }
            this.asyncBuffers.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            int toFill = -1;
            try {
                byte[][] byArray = this.asyncBuffers;
                // MONITORENTER : this.asyncBuffers
                for (int i = 0; i < this._bufferCount; ++i) {
                    if (this.status[i] != 0) continue;
                    this.status[i] = 1;
                    toFill = i;
                    break;
                }
                if (toFill == -1) {
                    this.asyncBuffers.wait();
                }
                // MONITOREXIT : byArray
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (toFill == -1) continue;
            long before = System.currentTimeMillis();
            this.doFill(this.asyncBuffers[toFill]);
            long after = System.currentTimeMillis();
            byte[][] byArray = this.asyncBuffers;
            // MONITORENTER : this.asyncBuffers
            this.status[toFill] = 2;
            this.asyncBuffers.notifyAll();
            // MONITOREXIT : byArray
            this._context.statManager().addRateData("prng.bufferFillTime", after - before, 0L);
            Thread.yield();
            long waitTime = (after - before) * 5L;
            if (waitTime <= 0L) {
                waitTime = 50L;
            }
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    public void fillBlock() {
        this.rotateBuffer();
    }

    private void doFill(byte[] buf) {
        long start = System.currentTimeMillis();
        if (this.pool0Count >= 64 && System.currentTimeMillis() - this.lastReseed > 100L) {
            ++this.reseedCount;
            for (int i = 0; i < 32; ++i) {
                if (this.reseedCount % (1 << i) != 0) continue;
                this.generator.addRandomBytes(this.pools[i].digest());
            }
            this.lastReseed = System.currentTimeMillis();
        }
        this.generator.nextBytes(buf);
    }

    public static void main(String[] args) {
        try {
            AsyncFortunaStandalone rand = new AsyncFortunaStandalone(null);
            byte[] seed = new byte[1024];
            rand.seed(seed);
            System.out.println("Before starting prng");
            rand.startup();
            System.out.println("Starting prng, waiting 1 minute");
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            System.out.println("PRNG started, beginning test");
            long before = System.currentTimeMillis();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            for (int i = 0; i < 1024; ++i) {
                rand.nextBytes(buf);
                gos.write(buf);
            }
            long after = System.currentTimeMillis();
            gos.finish();
            byte[] compressed = baos.toByteArray();
            System.out.println("Compressed size of 1MB: " + compressed.length + " took " + (after - before));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(300000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

