/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.web;

import i2p.bote.I2PBote;
import i2p.bote.Util;
import i2p.bote.network.BannedPeer;
import i2p.bote.network.DhtPeerStats;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import net.i2p.util.Log;

public class PeerInfoTag
extends SimpleTagSupport {
    private Log log = new Log(PeerInfoTag.class);

    public void doTag() {
        PageContext pageContext = (PageContext)this.getJspContext();
        JspWriter out = pageContext.getOut();
        try {
            DhtPeerStats dhtStats = I2PBote.getInstance().getDhtStats();
            if (dhtStats == null) {
                return;
            }
            int numPeers = dhtStats.getData().size();
            out.println("<strong>" + Util._((String)"Kademlia Peers:") + " " + numPeers + "</strong>");
            if (numPeers > 0) {
                out.println("<table>");
                out.println("<tr>");
                for (String columnHeader : dhtStats.getHeader()) {
                    out.println("<th>" + columnHeader + "</th>");
                }
                out.println("</tr>");
                for (List row : dhtStats.getData()) {
                    out.println("<tr>");
                    for (String cellData : row) {
                        out.println("<td>" + cellData + "</td>");
                    }
                    out.println("</tr>");
                }
                out.println("</table>");
            }
            out.println("<p/><br/>");
            Collection bannedPeers = I2PBote.getInstance().getBannedPeers();
            out.println("<strong>" + Util._((String)"Banned Peers:") + " " + bannedPeers.size() + "</strong>");
            if (bannedPeers.size() > 0) {
                out.println("<table>");
                out.println("<tr>");
                out.println("<th>" + Util._((String)"Peer") + "</th>");
                out.println("<th>" + Util._((String)"Destination Hash") + "</th>");
                out.println("<th>" + Util._((String)"Ban Reason") + "</th>");
                out.println("</tr>");
                int peerIndex = 1;
                for (BannedPeer peer : bannedPeers) {
                    out.println("<tr>");
                    out.println("<td>" + peerIndex++ + "</td>");
                    out.println("<td>" + peer.getDestination().calculateHash().toBase64() + "</td>");
                    out.println("<td>" + (peer.getBanReason() == null ? "" : peer.getBanReason()) + "</td>");
                    out.println("</tr>");
                }
                out.println("</table>");
            }
        }
        catch (IOException e) {
            this.log.error("Can't write output to HTML page", (Throwable)e);
        }
    }
}

