/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.web;

import i2p.bote.Configuration;
import i2p.bote.I2PBote;
import i2p.bote.addressbook.AddressBook;
import i2p.bote.addressbook.Contact;
import i2p.bote.email.Email;
import i2p.bote.email.EmailDestination;
import i2p.bote.email.EmailIdentity;
import i2p.bote.email.Identities;
import i2p.bote.folder.EmailFolder;
import i2p.bote.network.NetworkStatus;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.MessagingException;
import net.i2p.data.DataFormatException;

/*
 * Exception performing whole class analysis ignored.
 */
public class JSPHelper {
    public static NetworkStatus getNetworkStatus() {
        return I2PBote.getInstance().getNetworkStatus();
    }

    public static Identities getIdentities() {
        return I2PBote.getInstance().getIdentities();
    }

    public static AddressBook getAddressBook() {
        return I2PBote.getInstance().getAddressBook();
    }

    public static String getLocalDestination() {
        return I2PBote.getInstance().getLocalDestination().calculateHash().toBase64();
    }

    public static String saveIdentity(String key, String publicName, String description, String emailAddress, boolean setDefault) {
        Identities identities = JSPHelper.getIdentities();
        EmailIdentity identity = identities.get(key);
        if (identity != null) {
            identity.setPublicName(publicName);
            identity.setDescription(description);
            identity.setEmailAddress(emailAddress);
        } else {
            identity = new EmailIdentity();
            identity.setPublicName(publicName);
            identity.setDescription(description);
            identity.setEmailAddress(emailAddress);
            identities.add(identity);
        }
        if (setDefault) {
            identities.setDefault(identity);
        }
        try {
            identities.save();
            return null;
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    public static String deleteIdentity(String key) {
        Identities identities = JSPHelper.getIdentities();
        identities.remove(key);
        try {
            identities.save();
            return null;
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    public static String saveContact(String destinationString, String name) {
        AddressBook addressBook = JSPHelper.getAddressBook();
        Contact contact = addressBook.get(destinationString);
        if (contact != null) {
            contact.setName(name);
        } else {
            EmailDestination destination;
            try {
                destination = new EmailDestination(destinationString);
            }
            catch (DataFormatException e) {
                return e.getLocalizedMessage();
            }
            contact = new Contact(destination, name);
            addressBook.add(contact);
        }
        try {
            addressBook.save();
            return null;
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    public static String deleteContact(String destination) {
        AddressBook addressBook = JSPHelper.getAddressBook();
        addressBook.remove(destination);
        try {
            addressBook.save();
            return null;
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
    }

    public static Contact getContact(String destination) {
        return JSPHelper.getAddressBook().get(destination);
    }

    public static void checkForMail() {
        I2PBote.getInstance().checkForMail();
    }

    public static boolean isCheckingForMail() {
        return I2PBote.getInstance().isCheckingForMail();
    }

    public static boolean newMailReceived() {
        return I2PBote.getInstance().newMailReceived();
    }

    public static EmailFolder getMailFolder(String folderName) {
        if ("Inbox".equals(folderName)) {
            return I2PBote.getInstance().getInbox();
        }
        return null;
    }

    public static Email getEmail(String folderName, String messageId) {
        return JSPHelper.getMailFolder((String)folderName).getEmail(messageId);
    }

    public static String getOneLocalRecipient(Email email) {
        Address[] recipients;
        try {
            recipients = email.getAllRecipients();
        }
        catch (MessagingException e) {
            return null;
        }
        Identities identities = JSPHelper.getIdentities();
        for (EmailIdentity localDestination : identities) {
            String base64Dest = localDestination.toBase64();
            for (Address recipient : recipients) {
                String recipientString = recipient.toString();
                if (!recipientString.contains(base64Dest)) continue;
                return recipientString;
            }
        }
        return null;
    }

    public static boolean deleteEmail(String folderName, String messageId) {
        return JSPHelper.getMailFolder((String)folderName).delete(messageId);
    }

    public static EmailDestination extractEmailDestination(String address) {
        if (address == null) {
            return null;
        }
        String destinationString = null;
        if (address.length() == 512) {
            destinationString = address;
        } else {
            int ltIndex = address.indexOf(60);
            int gtIndex = address.indexOf(62);
            if (ltIndex >= 0 && ltIndex + 513 == gtIndex) {
                destinationString = address.substring(ltIndex, gtIndex + 1);
            }
        }
        if (destinationString == null) {
            return null;
        }
        try {
            return new EmailDestination(destinationString);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    public static SortedMap<String, String> getRecipients(Map<String, String> parameters) {
        TreeMap<String, String> newMap = new TreeMap<String, String>();
        for (String key : parameters.keySet()) {
            String value;
            String indexString;
            if (key == null || !key.startsWith("recipient") || !JSPHelper.isNumeric((String)(indexString = key.substring("recipient".length()))) || (value = parameters.get(key)) == null || value.isEmpty()) continue;
            newMap.put(key, value);
        }
        return newMap;
    }

    public Configuration getConfiguration() {
        return I2PBote.getInstance().getConfiguration();
    }

    public String getAppVersion() {
        return I2PBote.getAppVersion();
    }

    public String getLanguage() {
        return I2PBote.getInstance().getLanguage();
    }

    private static boolean isNumeric(String str) {
        return Pattern.matches("\\d+", str);
    }

    public static String extractName(String address) {
        if (address == null) {
            return "";
        }
        int ltIndex = address.indexOf(60);
        if (ltIndex >= 0) {
            return address.substring(0, ltIndex);
        }
        return "";
    }
}

