/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.service;

import com.nettgryppa.security.HashCash;
import i2p.bote.Configuration;
import i2p.bote.folder.PacketFolder;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.packet.RelayPacket;
import i2p.bote.service.I2PBoteThread;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class RelayPacketSender
extends I2PBoteThread {
    private static final long PAUSE = 600000L;
    private static final long EXPIRED_CHECK_INTERVAL = TimeUnit.DAYS.toMillis(1L);
    private static final int PADDED_SIZE = 16384;
    private static final Log log = new Log(RelayPacketSender.class);
    private I2PSendQueue sendQueue;
    private I2PAppContext appContext;
    private PacketFolder<RelayPacket> packetStore;
    private Configuration configuration;

    public RelayPacketSender(I2PSendQueue sendQueue, PacketFolder<RelayPacket> packetStore, I2PAppContext appContext) {
        super("RelayPacketSender");
        this.sendQueue = sendQueue;
        this.packetStore = packetStore;
        this.appContext = appContext;
    }

    public void run() {
        long lastExpiredCheck = 0L;
        while (true) {
            if (System.currentTimeMillis() - lastExpiredCheck > EXPIRED_CHECK_INTERVAL) {
                lastExpiredCheck = System.currentTimeMillis();
                log.debug("Checking for expired relay packets...");
                try {
                    this.deleteExpiredPackets();
                }
                catch (Exception e) {
                    log.error("Error deleting expired packets", (Throwable)e);
                }
            }
            log.info("Processing outgoing packets in directory '" + this.packetStore.getStorageDirectory().getAbsolutePath() + "'");
            for (RelayPacket packet : this.packetStore) {
                log.info("Processing packet file for destination <" + packet.getNextDestination().calculateHash() + ">");
                try {
                    HashCash hashCash = null;
                    long sendTime = this.getRandomSendTime(packet);
                    this.sendQueue.sendRelayRequest(packet, hashCash, sendTime);
                }
                catch (Exception e) {
                    log.error("Error sending packet. ", (Throwable)e);
                }
            }
            try {
                Thread.sleep(600000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("RelayPacketSender received an InterruptedException.");
                continue;
            }
            break;
        }
    }

    private long getRandomSendTime(RelayPacket packet) {
        long min = packet.getEarliestSendTime();
        long max = packet.getLatestSendTime();
        return min + RandomSource.getInstance().nextLong(max - min);
    }

    public void deleteExpiredPackets() throws ParseException {
    }
}

