/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.service;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

public class I2PBoteThread
extends I2PAppThread {
    private Log log = new Log(I2PBoteThread.class);
    private CountDownLatch shutdownSignal = new CountDownLatch(1);

    protected I2PBoteThread(String name) {
        super(name);
    }

    public void requestShutdown() {
        this.shutdownSignal.countDown();
    }

    public boolean awaitShutdownRequest(long timeout, TimeUnit unit) {
        try {
            return this.shutdownSignal.await(timeout, unit);
        }
        catch (InterruptedException e) {
            this.log.error("Interrupted in thread <" + this.getName() + ">", (Throwable)e);
            return true;
        }
    }

    public boolean shutdownRequested() {
        return this.awaitShutdownRequest(0L, TimeUnit.SECONDS);
    }
}

