/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.service;

import i2p.bote.I2PBote;
import i2p.bote.network.NetworkStatus;
import i2p.bote.service.I2PBoteThread;
import java.util.concurrent.TimeUnit;

public class AutoMailCheckTask
extends I2PBoteThread {
    private long interval;

    public AutoMailCheckTask(int interval) {
        super("AutoMailChk");
        this.interval = TimeUnit.MINUTES.toMillis(interval);
    }

    public void run() {
        while (!this.shutdownRequested()) {
            I2PBote boteInstance = I2PBote.getInstance();
            long timeSinceLastCheck = System.currentTimeMillis() - boteInstance.getLastMailCheckTime();
            if (boteInstance.getNetworkStatus() != NetworkStatus.CONNECTED) {
                this.awaitShutdownRequest(1L, TimeUnit.MINUTES);
                continue;
            }
            if (timeSinceLastCheck < this.interval) {
                this.awaitShutdownRequest(this.interval - timeSinceLastCheck, TimeUnit.MILLISECONDS);
                continue;
            }
            if (!boteInstance.getConfiguration().isAutoMailCheckEnabled()) continue;
            boteInstance.checkForMail();
            this.awaitShutdownRequest(1L, TimeUnit.MINUTES);
        }
    }
}

