/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet.dht;

import com.nettgryppa.security.HashCash;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.MalformedDataPacketException;
import i2p.bote.packet.TypeCode;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import net.i2p.data.Hash;
import net.i2p.util.Log;

@TypeCode(value=83)
public class StoreRequest
extends CommunicationPacket {
    private Log log = new Log(StoreRequest.class);
    private HashCash hashCash;
    private DhtStorablePacket packetToStore;

    public StoreRequest(HashCash hashCash, DhtStorablePacket packetToStore) {
        this.hashCash = hashCash;
        this.packetToStore = packetToStore;
    }

    public StoreRequest(byte[] data) throws NoSuchAlgorithmException, MalformedDataPacketException {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 38, data.length - 38);
        short hashCashLength = buffer.getShort();
        byte[] hashCashData = new byte[hashCashLength];
        buffer.get(hashCashData);
        this.hashCash = new HashCash(new String(hashCashData));
        short dataLength = buffer.getShort();
        byte[] storedData = new byte[dataLength];
        buffer.get(storedData);
        this.packetToStore = DhtStorablePacket.createPacket((byte[])storedData);
        if (buffer.hasRemaining()) {
            this.log.debug("Storage Request Packet has " + buffer.remaining() + " extra bytes.");
        }
    }

    public Hash getKey() {
        return this.packetToStore.getDhtKey();
    }

    public DhtStorablePacket getPacketToStore() {
        return this.packetToStore;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteArrayStream);
        try {
            this.writeHeader((OutputStream)dataStream);
            String hashCashString = this.hashCash.toString();
            dataStream.writeShort(hashCashString.length());
            dataStream.write(hashCashString.getBytes());
            byte[] dataToStore = this.packetToStore.toByteArray();
            dataStream.writeShort(dataToStore.length);
            dataStream.write(dataToStore);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return byteArrayStream.toByteArray();
    }
}

