/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet.dht;

import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.data.Hash;
import net.i2p.util.Log;

@TypeCode(value=70)
public class FindClosePeersPacket
extends CommunicationPacket {
    private Log log = new Log(FindClosePeersPacket.class);
    private Hash key;

    public FindClosePeersPacket(Hash key) {
        this.key = key;
    }

    public FindClosePeersPacket(byte[] data) {
        super(data);
        byte[] hashData = new byte[32];
        System.arraycopy(data, 38, hashData, 0, hashData.length);
        this.key = new Hash(hashData);
        int remaining = data.length - (38 + hashData.length);
        if (remaining > 0) {
            this.log.debug("Find Close Nodes Request packet has " + remaining + " extra bytes.");
        }
    }

    public Hash getKey() {
        return this.key;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.writeHeader((OutputStream)outputStream);
            outputStream.write(this.key.toByteArray());
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return outputStream.toByteArray();
    }

    public String toString() {
        return super.toString() + " key=" + this.key.toBase64().substring(0, 8) + "...";
    }
}

