/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.UniqueId;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.MalformedDataPacket;
import i2p.bote.packet.MalformedDataPacketException;
import i2p.bote.packet.StatusCode;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.i2p.util.Log;

@TypeCode(value=78)
public class ResponsePacket
extends CommunicationPacket {
    private Log log = new Log(ResponsePacket.class);
    private StatusCode statusCode;
    private DataPacket payload;

    public ResponsePacket(DataPacket payload, StatusCode statusCode, UniqueId packetId) {
        super(packetId);
        this.payload = payload;
        this.statusCode = statusCode;
    }

    public ResponsePacket(byte[] data) {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 38, data.length - 38);
        this.statusCode = StatusCode.values()[buffer.get()];
        short payloadLength = buffer.getShort();
        if (payloadLength > 0) {
            byte[] payloadData = new byte[payloadLength];
            buffer.get(payloadData);
            try {
                this.payload = DataPacket.createPacket((byte[])payloadData);
            }
            catch (MalformedDataPacketException e) {
                this.payload = new MalformedDataPacket();
            }
        }
        if (buffer.hasRemaining()) {
            this.log.debug("Response Packet has " + buffer.remaining() + " extra bytes.");
        }
    }

    public DataPacket getPayload() {
        return this.payload;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            this.writeHeader((OutputStream)dataStream);
            dataStream.write(this.statusCode.ordinal());
            if (this.payload == null) {
                dataStream.writeShort(0);
            } else {
                byte[] payloadBytes = this.payload.toByteArray();
                dataStream.writeShort(payloadBytes.length);
                dataStream.write(payloadBytes);
            }
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return byteStream.toByteArray();
    }

    public String toString() {
        String payloadClassName = this.payload == null ? "<null>" : this.payload.getClass().getSimpleName();
        return super.toString() + ", status=" + this.statusCode + ", ploadType=" + payloadClassName;
    }
}

