/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.UniqueId;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.util.Log;

@TypeCode(value=88)
public class IndexPacketDeleteRequest
extends CommunicationPacket {
    private Log log = new Log(IndexPacketDeleteRequest.class);
    private Hash emailDestHash;
    private Map<Hash, UniqueId> entries;

    public IndexPacketDeleteRequest(Hash emailDestHash) {
        this.emailDestHash = emailDestHash;
        this.entries = new HashMap();
    }

    public IndexPacketDeleteRequest(byte[] data) {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 38, data.length - 38);
        this.emailDestHash = this.readHash(buffer);
        this.entries = new HashMap();
        int numEntries = buffer.getShort();
        for (int i = 0; i < numEntries; ++i) {
            Hash dhtKey = this.readHash(buffer);
            UniqueId deletionKey = new UniqueId(buffer);
            this.entries.put(dhtKey, deletionKey);
        }
        if (buffer.hasRemaining()) {
            this.log.debug("Index Packet Delete Request has " + buffer.remaining() + " extra bytes.");
        }
    }

    public void put(Hash dhtKey, UniqueId deletionKey) {
        this.entries.put(dhtKey, deletionKey);
    }

    public Hash getEmailDestHash() {
        return this.emailDestHash;
    }

    public Set<Hash> getDhtKeys() {
        return this.entries.keySet();
    }

    public UniqueId getDeletionKey(Hash dhtKey) {
        return (UniqueId)this.entries.get(dhtKey);
    }

    public void remove(Hash dhtKey) {
        this.entries.remove(dhtKey);
    }

    public int getNumEntries() {
        return this.entries.size();
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            this.writeHeader((OutputStream)dataStream);
            this.emailDestHash.writeBytes((OutputStream)dataStream);
            dataStream.writeShort(this.entries.size());
            for (Map.Entry entry : this.entries.entrySet()) {
                dataStream.write(((Hash)entry.getKey()).toByteArray());
                dataStream.write(((UniqueId)entry.getValue()).toByteArray());
            }
        }
        catch (DataFormatException e) {
            this.log.error("Invalid format for email destination.", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return byteStream.toByteArray();
    }
}

