/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.UniqueId;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.i2p.data.Hash;
import net.i2p.util.Log;

@TypeCode(value=68)
public class EmailPacketDeleteRequest
extends CommunicationPacket {
    private Log log = new Log(EmailPacketDeleteRequest.class);
    private Hash dhtKey;
    private UniqueId deletionKey;

    public EmailPacketDeleteRequest(Hash dhtKey, UniqueId deletionKey) {
        this.dhtKey = dhtKey;
        this.deletionKey = deletionKey;
    }

    public EmailPacketDeleteRequest(byte[] data) {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 38, data.length - 38);
        this.dhtKey = this.readHash(buffer);
        this.deletionKey = new UniqueId(buffer);
        if (buffer.hasRemaining()) {
            this.log.debug("Email Packet Delete Request has " + buffer.remaining() + " extra bytes.");
        }
    }

    public Hash getDhtKey() {
        return this.dhtKey;
    }

    public UniqueId getDeletionKey() {
        return this.deletionKey;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.writeHeader((OutputStream)outputStream);
            outputStream.write(this.dhtKey.toByteArray());
            outputStream.write(this.deletionKey.toByteArray());
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return outputStream.toByteArray();
    }
}

