/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.Util;
import i2p.bote.packet.I2PBotePacket;
import i2p.bote.packet.MalformedDataPacketException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.util.Log;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class DataPacket
extends I2PBotePacket {
    protected static final int HEADER_LENGTH = 2;
    private static Log log = new Log(DataPacket.class);

    public DataPacket() {
    }

    public DataPacket(byte[] data) {
        super((int)data[1]);
        if (data[0] != this.getPacketTypeCode()) {
            log.error("Wrong type code for " + this.getClass().getSimpleName() + ". Expected <" + this.getPacketTypeCode() + ">, got <" + (char)data[0] + ">");
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    protected void writeHeader(OutputStream outputStream) throws IOException {
        outputStream.write((byte)this.getPacketTypeCode());
        outputStream.write(this.getProtocolVersion());
    }

    public static DataPacket createPacket(File file) throws MalformedDataPacketException {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            DataPacket packet;
            inputStream = new FileInputStream(file);
            DataPacket dataPacket = packet = DataPacket.createPacket((byte[])Util.readInputStream((InputStream)inputStream));
            return dataPacket;
        }
        catch (IOException e) {
            throw new MalformedDataPacketException("Can't read packet file: " + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                log.error("Can't close stream.", (Throwable)e);
            }
        }
    }

    public static DataPacket createPacket(byte[] data) throws MalformedDataPacketException {
        char packetTypeCode = (char)data[0];
        Class packetType = DataPacket.decodePacketTypeCode((char)packetTypeCode);
        if (packetType == null || !DataPacket.class.isAssignableFrom(packetType)) {
            log.error("Type code is not a DataPacket type code: <" + packetTypeCode + ">");
            return null;
        }
        Class<DataPacket> dataPacketType = packetType.asSubclass(DataPacket.class);
        DataPacket packet = null;
        try {
            packet = dataPacketType.getConstructor(byte[].class).newInstance(new Object[]{data});
        }
        catch (Exception e) {
            throw new MalformedDataPacketException("Can't instantiate packet for type code <" + packetTypeCode + ">", (Throwable)e);
        }
        if (packet.getProtocolVersion() != 2) {
            log.warn("Ignoring " + packetType.getSimpleName() + " packet with protocol version " + packet.getProtocolVersion());
            return null;
        }
        return packet;
    }
}

