/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.Util;
import i2p.bote.network.DhtPeerStats;
import i2p.bote.network.kademlia.AbstractBucket;
import i2p.bote.network.kademlia.KBucket;
import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.network.kademlia.KademliaUtil;
import i2p.bote.network.kademlia.SBucket;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.data.Hash;

public class KademliaPeerStats
implements DhtPeerStats {
    private List<String> header;
    private List<List<String>> data;

    KademliaPeerStats(SBucket sBucket, List<KBucket> kBuckets, Hash localDestinationHash) {
        String[] headerArray = new String[]{Util._((String)"Peer"), Util._((String)"I2P Destination"), Util._((String)"BktPfx"), Util._((String)"Distance"), Util._((String)"Locked?"), Util._((String)"Active Since")};
        this.header = Arrays.asList(headerArray);
        this.data = new ArrayList();
        this.addPeerData((AbstractBucket)sBucket, localDestinationHash);
        for (KBucket kBucket : kBuckets) {
            this.addPeerData((AbstractBucket)kBucket, localDestinationHash);
        }
    }

    private void addPeerData(AbstractBucket bucket, Hash localDestinationHash) {
        DateFormat formatter = DateFormat.getDateTimeInstance();
        for (KademliaPeer peer : bucket) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(String.valueOf(this.data.size() + 1));
            row.add(peer.calculateHash().toBase64());
            row.add(this.getBucketPrefix(bucket));
            BigInteger distance = KademliaUtil.getDistance((Hash)localDestinationHash, (Hash)peer.calculateHash());
            row.add(distance.shiftRight(240).toString());
            row.add(String.valueOf(peer.isLocked() ? Util._((String)"Yes") + "(" + peer.getConsecTimeouts() + ")" : Util._((String)"No")));
            String activeSince = formatter.format(peer.getActiveSince());
            row.add(String.valueOf(activeSince));
            this.data.add(row);
        }
    }

    private String getBucketPrefix(AbstractBucket bucket) {
        if (bucket instanceof KBucket) {
            KBucket kBucket = (KBucket)bucket;
            String prefix = kBucket.getBucketPrefix();
            if (prefix.isEmpty()) {
                return Util._((String)"(None)");
            }
            return prefix;
        }
        return Util._((String)"(S)");
    }

    public List<String> getHeader() {
        return this.header;
    }

    public List<List<String>> getData() {
        return this.data;
    }
}

