/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public class KademliaPeer
extends Destination {
    private Log log = new Log(KademliaPeer.class);
    private Destination destination;
    private Hash destinationHash;
    private long activeSince;
    private volatile int consecutiveTimeouts;
    private long lockedUntil;

    public KademliaPeer(Destination destination, long lastReception) {
        this.setCertificate(destination.getCertificate());
        this.setSigningPublicKey(destination.getSigningPublicKey());
        this.setPublicKey(destination.getPublicKey());
        this.destination = destination;
        this.destinationHash = destination.calculateHash();
        if (this.destinationHash == null) {
            this.log.error("calculateHash() returned null!");
        }
        this.activeSince = lastReception;
    }

    public KademliaPeer(Destination destination) {
        this(destination, System.currentTimeMillis());
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Hash getDestinationHash() {
        return this.destinationHash;
    }

    void setActiveSince(long activeSince) {
        this.activeSince = activeSince;
    }

    public long getActiveSince() {
        return this.activeSince;
    }

    public int getConsecTimeouts() {
        return this.consecutiveTimeouts;
    }

    long getLockedUntil() {
        return this.lockedUntil;
    }

    boolean isLocked() {
        return this.lockedUntil > System.currentTimeMillis();
    }

    synchronized void noResponse() {
        ++this.consecutiveTimeouts;
        int lockDuration = 1 << Math.min(this.consecutiveTimeouts, 10);
        this.lockedUntil = System.currentTimeMillis() + (long)(60000 * lockDuration);
    }

    void responseReceived() {
        this.consecutiveTimeouts = 0;
        this.lockedUntil = 0L;
    }
}

