/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import com.nettgryppa.security.HashCash;
import i2p.bote.Util;
import i2p.bote.network.DHT;
import i2p.bote.network.DhtException;
import i2p.bote.network.DhtPeerStats;
import i2p.bote.network.DhtResults;
import i2p.bote.network.DhtStorageHandler;
import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PacketBatch;
import i2p.bote.network.PacketListener;
import i2p.bote.network.kademlia.AbstractBucket;
import i2p.bote.network.kademlia.BucketManager;
import i2p.bote.network.kademlia.ClosestNodesLookupTask;
import i2p.bote.network.kademlia.KBucket;
import i2p.bote.network.kademlia.KademliaDHT;
import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.network.kademlia.PeerDistanceComparator;
import i2p.bote.network.kademlia.SBucket;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.PeerList;
import i2p.bote.packet.ResponsePacket;
import i2p.bote.packet.StatusCode;
import i2p.bote.packet.dht.DhtStorablePacket;
import i2p.bote.packet.dht.FindClosePeersPacket;
import i2p.bote.packet.dht.RetrieveRequest;
import i2p.bote.packet.dht.StoreRequest;
import i2p.bote.service.I2PBoteThread;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class KademliaDHT
extends I2PBoteThread
implements DHT,
PacketListener {
    private static final int RESPONSE_TIMEOUT = 60;
    private static final URL BUILT_IN_PEER_FILE = KademliaDHT.class.getResource("built-in-peers.txt");
    private Log log = new Log(KademliaDHT.class);
    private Destination localDestination;
    private Hash localDestinationHash;
    private I2PSendQueue sendQueue;
    private I2PPacketDispatcher i2pReceiver;
    private File peerFile;
    private Set<KademliaPeer> initialPeers;
    private BucketManager bucketManager;
    private Map<Class<? extends DhtStorablePacket>, DhtStorageHandler> storageHandlers;
    private volatile boolean connected;

    public KademliaDHT(Destination localDestination, I2PSendQueue sendQueue, I2PPacketDispatcher i2pReceiver, File peerFile) {
        super("Kademlia");
        this.localDestination = localDestination;
        this.localDestinationHash = localDestination.calculateHash();
        this.sendQueue = sendQueue;
        this.i2pReceiver = i2pReceiver;
        this.peerFile = peerFile;
        this.initialPeers = new ConcurrentHashSet();
        this.readPeers(BUILT_IN_PEER_FILE);
        if (peerFile.exists()) {
            this.readPeers(peerFile);
        } else {
            this.log.info("Peer file doesn't exist, using built-in peers only (File not found: <" + peerFile.getAbsolutePath() + ">)");
        }
        this.bucketManager = new BucketManager(this.localDestinationHash);
        this.storageHandlers = new ConcurrentHashMap();
    }

    private List<Destination> getClosestNodes(Hash key) {
        this.bucketManager.getKBucket(key).setLastLookupTime(System.currentTimeMillis());
        this.bucketManager.getSBucket().setLastLookupTime(key, System.currentTimeMillis());
        ClosestNodesLookupTask lookupTask = new ClosestNodesLookupTask(key, this.sendQueue, this.i2pReceiver, this.bucketManager);
        lookupTask.run();
        return lookupTask.getResults();
    }

    public DhtResults findOne(Hash key, Class<? extends DhtStorablePacket> dataType) {
        return this.find(key, dataType, false);
    }

    public DhtResults findAll(Hash key, Class<? extends DhtStorablePacket> dataType) {
        return this.find(key, dataType, true);
    }

    public void setStorageHandler(Class<? extends DhtStorablePacket> packetType, DhtStorageHandler storageHandler) {
        this.storageHandlers.put(packetType, storageHandler);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getNumPeers() {
        return this.bucketManager.getPeerCount();
    }

    public DhtPeerStats getPeerStats() {
        return this.bucketManager.getPeerStats();
    }

    private DhtResults find(Hash key, Class<? extends DhtStorablePacket> dataType, boolean exhaustive) {
        List closeNodes = this.getClosestNodes(key);
        this.log.debug("Querying localhost + " + closeNodes.size() + " peers for data type " + dataType.getSimpleName() + ", Kademlia key " + key);
        DhtStorablePacket localResult = this.findLocally(key, dataType);
        if (!exhaustive && localResult != null) {
            this.log.debug("Locally stored packet found for hash " + key + " and data type " + dataType);
            DhtResults results = new DhtResults();
            results.put(this.localDestination, localResult);
            return results;
        }
        PacketBatch batch = new PacketBatch();
        for (Destination node : closeNodes) {
            batch.putPacket((CommunicationPacket)new RetrieveRequest(key, dataType), node);
        }
        this.sendQueue.send(batch);
        try {
            batch.awaitSendCompletion();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for Retrieve Requests to be sent.", (Throwable)e);
        }
        try {
            if (exhaustive) {
                batch.awaitAllResponses(60L, TimeUnit.SECONDS);
            } else {
                batch.awaitFirstReply(60L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for responses to Retrieve Requests.", (Throwable)e);
        }
        this.log.debug(batch.getResponses().size() + " response packets received for hash " + key + " and data type " + dataType);
        this.sendQueue.remove(batch);
        return this.getDhtResults(batch, localResult);
    }

    private DhtStorablePacket findLocally(Hash key, Class<? extends DhtStorablePacket> dataType) {
        DhtStorageHandler storageHandler = (DhtStorageHandler)this.storageHandlers.get(dataType);
        if (storageHandler != null) {
            return storageHandler.retrieve(key);
        }
        return null;
    }

    private DhtResults getDhtResults(PacketBatch batch, DhtStorablePacket localResult) {
        DhtResults results = new DhtResults();
        for (Map.Entry result : batch.getResponses().entrySet()) {
            DataPacket packet = (DataPacket)result.getValue();
            if (!(packet instanceof DhtStorablePacket)) continue;
            results.put((Destination)result.getKey(), (DhtStorablePacket)packet);
        }
        if (localResult != null) {
            results.put(this.localDestination, localResult);
        }
        return results;
    }

    public void store(DhtStorablePacket packet) throws DhtException {
        HashCash hashCash;
        Hash key = packet.getDhtKey();
        List closeNodes = this.getClosestNodes(key);
        if (closeNodes.isEmpty()) {
            throw new DhtException("Cannot store packet because no storage nodes found.");
        }
        if (closeNodes.size() < 20 || this.isCloser(this.localDestination, (Destination)closeNodes.get(0), key)) {
            closeNodes.add(this.localDestination);
        }
        this.log.debug("Storing a " + packet.getClass().getSimpleName() + " with key " + key + " on " + closeNodes.size() + " nodes");
        try {
            hashCash = HashCash.mintCash((String)"", (int)1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DhtException("Cannot mint HashCash.", (Throwable)e);
        }
        PacketBatch batch = new PacketBatch();
        for (Destination node : closeNodes) {
            StoreRequest storeRequest = new StoreRequest(hashCash, packet);
            batch.putPacket((CommunicationPacket)storeRequest, node);
        }
        this.sendQueue.send(batch);
        try {
            batch.awaitSendCompletion();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while waiting for responses to Storage Requests to be sent.", (Throwable)e);
        }
        this.sendQueue.remove(batch);
    }

    private boolean isCloser(Destination dest1, Destination dest2, Hash key) {
        return new PeerDistanceComparator(key).compare(dest1, dest2) < 0;
    }

    private void bootstrap() {
        new BootstrapTask(this, this.i2pReceiver).run();
    }

    public void refreshAll() {
        for (KBucket bucket : Util.synchronizedCopy((Iterable)this.bucketManager)) {
            this.refresh(bucket);
        }
    }

    private void refreshOldBuckets() {
        long now = System.currentTimeMillis();
        for (KBucket bucket : Util.synchronizedCopy((Iterable)this.bucketManager)) {
            if (now <= bucket.getLastLookupTime() + 3600000L) continue;
            this.log.debug("Refreshing bucket: " + bucket);
            this.refresh(bucket);
        }
        SBucket sBucket = this.bucketManager.getSBucket();
        for (SBucket.BucketSection section : sBucket.getSections()) {
            if (now <= section.getLastLookupTime() + 3600000L) continue;
            this.refresh((AbstractBucket)sBucket, section.getStart(), section.getEnd());
        }
    }

    private void refresh(KBucket bucket) {
        Hash key = this.createRandomHash(bucket.getStartId(), bucket.getEndId());
        this.getClosestNodes(key);
    }

    private void refresh(AbstractBucket bucket, BigInteger min, BigInteger max) {
        Hash key = this.createRandomHash(min, max);
        this.getClosestNodes(key);
    }

    private Hash createRandomHash(BigInteger min, BigInteger max) {
        BigInteger hashValue;
        if (min.compareTo(max) >= 0) {
            hashValue = min;
        } else {
            hashValue = new BigInteger(256, (Random)RandomSource.getInstance());
            hashValue = min.add(hashValue.mod(max.subtract(min)));
        }
        byte[] hashArray = hashValue.toByteArray();
        if (hashArray.length > 33 || hashArray.length == 33 && hashArray[0] != 0) {
            this.log.error("Hash value too big to fit in 32 bytes: " + hashValue);
        }
        byte[] hashArrayPadded = new byte[32];
        if (hashArray.length == 33) {
            System.arraycopy(hashArray, 1, hashArrayPadded, 0, 32);
        } else {
            System.arraycopy(hashArray, 0, hashArrayPadded, 32 - hashArray.length, hashArray.length);
        }
        return new Hash(hashArrayPadded);
    }

    private void writePeersSorted(File file) {
        List peers = this.bucketManager.getAllPeers();
        if (peers.isEmpty()) {
            return;
        }
        this.sortByUptime(peers);
        this.log.info("Writing peers to file: <" + file.getAbsolutePath() + ">");
        this.writePeers(peers, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePeers(List<KademliaPeer> peers, File file) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write("# Each line is one Base64-encoded I2P destination.");
            writer.newLine();
            writer.write("# Do not edit while I2P-Bote is running as it will be overwritten.");
            writer.newLine();
            for (KademliaPeer peer : peers) {
                writer.write(peer.toBase64());
                writer.newLine();
            }
        }
        catch (IOException e) {
            this.log.error("Can't write peers to file <" + file.getAbsolutePath() + ">", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.log.error("Can't close BufferedWriter for file <" + file.getAbsolutePath() + ">", (Throwable)e);
                }
            }
        }
    }

    private void sortByUptime(List<KademliaPeer> peers) {
        Collections.sort(peers, new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPeers(URL url) {
        this.log.info("Reading peers from URL: <" + url + ">");
        InputStream stream = null;
        try {
            stream = url.openStream();
            this.readPeers(stream);
        }
        catch (IOException e) {
            this.log.error("Error reading peers from URL.", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.log.error("Can't close input stream.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPeers(File file) {
        this.log.info("Reading peers from file: <" + file.getAbsolutePath() + ">");
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            this.readPeers((InputStream)stream);
        }
        catch (IOException e) {
            this.log.error("Error reading peers from file.", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {
                    this.log.error("Can't close input stream.", (Throwable)e);
                }
            }
        }
    }

    private void readPeers(InputStream inputStream) throws IOException {
        BufferedReader inputBuffer = new BufferedReader(new InputStreamReader(inputStream));
        int numPeersBefore = this.initialPeers.size();
        while (true) {
            String line = null;
            line = inputBuffer.readLine();
            if (line == null) break;
            if (line.startsWith("#")) continue;
            try {
                Destination destination = new Destination(line);
                KademliaPeer peer = new KademliaPeer(destination, 0L);
                if (peer.getDestination().equals((Object)this.localDestination)) continue;
                this.initialPeers.add(peer);
            }
            catch (DataFormatException e) {
                this.log.error("Invalid destination key in line " + line, (Throwable)e);
            }
        }
        this.log.debug(this.initialPeers.size() - numPeersBefore + " peers read.");
    }

    private void sendPeerList(FindClosePeersPacket packet, Destination destination) {
        List closestPeers = this.bucketManager.getClosestPeers(packet.getKey(), 20);
        PeerList peerList = new PeerList((Collection)closestPeers);
        this.sendQueue.sendResponse((DataPacket)peerList, destination, packet.getPacketId());
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        if (packet instanceof FindClosePeersPacket) {
            this.sendPeerList((FindClosePeersPacket)packet, sender);
        } else if (packet instanceof StoreRequest) {
            DhtStorablePacket packetToStore = ((StoreRequest)packet).getPacketToStore();
            if (packetToStore != null) {
                DhtStorageHandler storageHandler = (DhtStorageHandler)this.storageHandlers.get(packetToStore.getClass());
                if (storageHandler != null) {
                    storageHandler.store(packetToStore);
                } else {
                    this.log.warn("No storage handler found for type " + packetToStore.getClass().getSimpleName() + ".");
                }
            }
        } else if (packet instanceof RetrieveRequest) {
            RetrieveRequest retrieveRequest = (RetrieveRequest)packet;
            DhtStorageHandler storageHandler = (DhtStorageHandler)this.storageHandlers.get(retrieveRequest.getDataType());
            if (storageHandler != null) {
                DhtStorablePacket storedPacket = storageHandler.retrieve(retrieveRequest.getKey());
                ResponsePacket response = new ResponsePacket((DataPacket)storedPacket, StatusCode.OK, retrieveRequest.getPacketId());
                if (storedPacket != null) {
                    this.log.debug("Packet found for retrieve request: [" + retrieveRequest + "], replying to sender: [" + sender.calculateHash() + "]");
                } else {
                    this.log.debug("No matching packet found for retrieve request: [" + retrieveRequest + "]");
                }
                this.sendQueue.send((CommunicationPacket)response, sender);
            } else {
                this.log.warn("No storage handler found for type " + packet.getClass().getSimpleName() + ".");
            }
        }
        this.bucketManager.packetReceived(packet, sender, receiveTime);
    }

    public void run() {
        this.i2pReceiver.addPacketListener((PacketListener)this);
        this.bootstrap();
        this.connected = true;
        while (!this.shutdownRequested()) {
            if (this.bucketManager.getUnlockedPeerCount() == 0) {
                this.log.debug("All peers are gone. Re-bootstrapping.");
                this.bootstrap();
            }
            this.refreshOldBuckets();
            this.awaitShutdownRequest(1L, TimeUnit.MINUTES);
        }
        this.writePeersSorted(this.peerFile);
        this.i2pReceiver.removePacketListener((PacketListener)this);
    }

    public void awaitShutdown(long timeout) throws InterruptedException {
        this.join(timeout);
    }

    static /* synthetic */ Log access$000(KademliaDHT x0) {
        return x0.log;
    }

    static /* synthetic */ Set access$100(KademliaDHT x0) {
        return x0.initialPeers;
    }

    static /* synthetic */ BucketManager access$200(KademliaDHT x0) {
        return x0.bucketManager;
    }

    static /* synthetic */ Hash access$300(KademliaDHT x0) {
        return x0.localDestinationHash;
    }

    static /* synthetic */ List access$400(KademliaDHT x0, Hash x1) {
        return x0.getClosestNodes(x1);
    }
}

