/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.kademlia.AbstractBucket;
import i2p.bote.network.kademlia.KademliaPeer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.i2p.data.Destination;
import net.i2p.util.Log;

class KBucket
extends AbstractBucket {
    private static final int REPLACEMENT_CACHE_MAX_SIZE = 20;
    private Log log = new Log(KBucket.class);
    private BigInteger startId;
    private BigInteger endId;
    private List<KademliaPeer> replacementCache;
    private volatile int depth;
    private volatile long lastLookupTime;

    KBucket(BigInteger startId, BigInteger endId, int depth) {
        super(20);
        this.startId = startId;
        this.endId = endId;
        this.replacementCache = Collections.synchronizedList(new ArrayList());
        this.depth = depth;
    }

    synchronized BigInteger getStartId() {
        return this.startId;
    }

    synchronized BigInteger getEndId() {
        return this.endId;
    }

    public void setLastLookupTime(long lastLookupTime) {
        this.lastLookupTime = lastLookupTime;
    }

    public long getLastLookupTime() {
        return this.lastLookupTime;
    }

    boolean shouldSplit(Destination destination) {
        return this.isFull() && !this.contains(destination) && this.canSplit(destination);
    }

    private boolean canSplit(Destination destination) {
        return this.depth % 1 != 0 || this.rangeContains(destination);
    }

    void addOrUpdate(KademliaPeer peer) {
        int index = this.getPeerIndex((Destination)peer);
        if (index >= 0) {
            KademliaPeer existingPeer = (KademliaPeer)this.peers.remove(index);
            existingPeer.responseReceived();
            this.add(existingPeer);
        } else if (!this.isFull()) {
            this.add(peer);
        } else {
            this.addOrUpdateReplacement(peer);
        }
    }

    private void add(KademliaPeer peer) {
        if (this.isFull()) {
            this.log.error("Error: adding a node to a full k-bucket. Bucket needs to be split first. Size=" + this.size() + ", capacity=" + this.capacity);
        }
        if (peer.isLocked()) {
            this.peers.add(peer);
        } else {
            this.peers.add(0, peer);
        }
    }

    void noResponse(KademliaPeer peer) {
        if (!this.replacementCache.isEmpty() && this.peers.remove(peer)) {
            this.peers.add(this.replacementCache.remove(0));
        }
    }

    private void addOrUpdateReplacement(KademliaPeer peer) {
        if (this.replacementCache.contains(peer)) {
            this.replacementCache.remove(peer);
        }
        this.replacementCache.add(0, peer);
        while (this.replacementCache.size() > 20) {
            this.replacementCache.remove(19);
        }
    }

    private boolean rangeContains(Destination peer) {
        BigInteger peerHash = new BigInteger(1, peer.calculateHash().getData());
        return this.startId.compareTo(peerHash) <= 0 && this.endId.compareTo(peerHash) >= 0;
    }

    KBucket split() {
        BigInteger pivot = this.startId.add(this.endId).divide(BigInteger.valueOf(2L));
        return this.split(pivot);
    }

    private KBucket split(BigInteger pivot) {
        ++this.depth;
        KBucket newBucket = new KBucket(pivot, this.endId, this.depth);
        this.endId = pivot;
        for (int i = this.peers.size() - 1; i >= 0; --i) {
            KademliaPeer peer = (KademliaPeer)this.peers.get(i);
            BigInteger nodeId = new BigInteger(1, peer.getDestinationHash().getData());
            if (nodeId.compareTo(pivot) < 0) continue;
            newBucket.add(peer);
            this.remove((Destination)peer);
        }
        return newBucket;
    }

    String getBucketPrefix() {
        if (this.depth == 0) {
            return "(None)";
        }
        String binary = this.startId.toString(2);
        while (binary.length() < 256) {
            binary = "0" + binary;
        }
        return binary.substring(0, this.depth);
    }

    public String toString() {
        return "K-Bucket (depth=" + this.depth + ", prefix=" + this.getBucketPrefix() + ", lastLookup=" + new Date(this.lastLookupTime) + ", start=" + this.startId + ", end=" + this.endId + ")";
    }
}

