/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.Util;
import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PacketListener;
import i2p.bote.network.kademlia.BucketManager;
import i2p.bote.network.kademlia.ClosestNodesLookupTask;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.dht.FindClosePeersPacket;
import i2p.bote.service.I2PBoteThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public class ClosestNodesLookupTask
implements Runnable {
    private static final int REQUEST_TIMEOUT = 30000;
    private static final int CLOSEST_NODES_LOOKUP_TIMEOUT = 120000;
    private Log log = new Log(ClosestNodesLookupTask.class);
    private Hash key;
    private I2PPacketDispatcher i2pReceiver;
    private BucketManager bucketManager;
    private I2PSendQueue sendQueue;
    private Comparator<Destination> peerComparator;
    private SortedSet<Destination> responses;
    private SortedSet<Destination> notQueriedYet;
    private Map<Destination, FindClosePeersPacket> pendingRequests;
    private long startTime;

    public ClosestNodesLookupTask(Hash key, I2PSendQueue sendQueue, I2PPacketDispatcher i2pReceiver, BucketManager bucketManager) {
        this.key = key;
        this.sendQueue = sendQueue;
        this.i2pReceiver = i2pReceiver;
        this.bucketManager = bucketManager;
        this.peerComparator = new HashDistanceComparator(key);
        this.responses = Collections.synchronizedSortedSet(new TreeSet(this.peerComparator));
        this.notQueriedYet = Collections.synchronizedSortedSet(new TreeSet(this.peerComparator));
        this.pendingRequests = new ConcurrentHashMap();
    }

    @Override
    public void run() {
        this.log.debug("Looking up nodes closest to " + this.key);
        IncomingPacketHandler packetListener = new IncomingPacketHandler(this, null);
        this.i2pReceiver.addPacketListener((PacketListener)packetListener);
        this.notQueriedYet.addAll(this.bucketManager.getAllPeers());
        this.startTime = this.getTime();
        while (true) {
            if (this.pendingRequests.size() < 3 && !this.notQueriedYet.isEmpty()) {
                Destination peer = (Destination)this.notQueriedYet.first();
                this.notQueriedYet.remove(peer);
                FindClosePeersPacket packet = new FindClosePeersPacket(this.key);
                this.pendingRequests.put(peer, packet);
                this.sendQueue.send((CommunicationPacket)packet, peer);
                continue;
            }
            for (Map.Entry request : this.pendingRequests.entrySet()) {
                if (!this.hasTimedOut((CommunicationPacket)request.getValue(), 30000L)) continue;
                Destination peer = (Destination)request.getKey();
                this.bucketManager.noResponse(peer);
                this.pendingRequests.remove(peer);
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted while doing a closest nodes lookup.", (Throwable)e);
            }
            if (this.isDone()) break;
        }
        this.log.debug(this.responses.size() + " nodes found (may include local node).");
        for (Destination node : this.responses) {
            this.log.debug("  Node: " + node.calculateHash());
        }
        this.i2pReceiver.removePacketListener((PacketListener)packetListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDone() {
        if (this.pendingRequests.isEmpty() && this.notQueriedYet.isEmpty()) {
            return true;
        }
        Destination kthClosestResult = null;
        SortedSet sortedSet = this.responses;
        synchronized (sortedSet) {
            if (this.responses.size() >= 20) {
                kthClosestResult = (Destination)Util.get((Collection)this.responses, (int)19);
            }
        }
        if (kthClosestResult != null) {
            Destination closestUnqueriedPeer = null;
            SortedSet sortedSet2 = this.notQueriedYet;
            synchronized (sortedSet2) {
                if (this.notQueriedYet.isEmpty()) {
                    return true;
                }
                closestUnqueriedPeer = (Destination)this.notQueriedYet.first();
            }
            if (this.peerComparator.compare(kthClosestResult, closestUnqueriedPeer) <= 0) {
                return true;
            }
        }
        if (this.hasTimedOut(this.startTime, 120000L)) {
            this.log.error("Lookup for closest nodes timed out.");
            return true;
        }
        Thread currentThread = Thread.currentThread();
        return currentThread instanceof I2PBoteThread && ((I2PBoteThread)currentThread).shutdownRequested();
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    private boolean hasTimedOut(long startTime, long timeout) {
        return this.getTime() > startTime + timeout;
    }

    private boolean hasTimedOut(CommunicationPacket request, long timeout) {
        long sentTime = request.getSentTime();
        return sentTime > 0L && this.hasTimedOut(sentTime, timeout);
    }

    public List<Destination> getResults() {
        ArrayList<Destination> resultsList = new ArrayList<Destination>();
        for (Destination destination : this.responses) {
            resultsList.add(destination);
            if (resultsList.size() < 20) continue;
            break;
        }
        return resultsList;
    }

    static /* synthetic */ Map access$100(ClosestNodesLookupTask x0) {
        return x0.pendingRequests;
    }

    static /* synthetic */ SortedSet access$200(ClosestNodesLookupTask x0) {
        return x0.responses;
    }

    static /* synthetic */ Log access$300(ClosestNodesLookupTask x0) {
        return x0.log;
    }

    static /* synthetic */ SortedSet access$400(ClosestNodesLookupTask x0) {
        return x0.notQueriedYet;
    }
}

