/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.BanList;
import i2p.bote.network.DhtPeerStats;
import i2p.bote.network.PacketListener;
import i2p.bote.network.kademlia.AbstractBucket;
import i2p.bote.network.kademlia.KBucket;
import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.network.kademlia.KademliaPeerStats;
import i2p.bote.network.kademlia.PeerDistanceComparator;
import i2p.bote.network.kademlia.SBucket;
import i2p.bote.packet.CommunicationPacket;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

class BucketManager
implements PacketListener,
Iterable<KBucket> {
    private Log log = new Log(BucketManager.class);
    private List<KBucket> kBuckets;
    private SBucket sBucket;
    private Hash localDestinationHash;

    public BucketManager(Hash localDestinationHash) {
        this.localDestinationHash = localDestinationHash;
        this.kBuckets = Collections.synchronizedList(new ArrayList());
        this.kBuckets.add(new KBucket(AbstractBucket.MIN_HASH_VALUE, AbstractBucket.MAX_HASH_VALUE, 0));
        this.sBucket = new SBucket(localDestinationHash);
    }

    public void addAll(Collection<KademliaPeer> peers) {
        for (KademliaPeer node : peers) {
            this.addOrUpdate(node);
        }
    }

    public void addOrUpdate(KademliaPeer peer) {
        Hash destHash = peer.getDestinationHash();
        if (this.localDestinationHash.equals((Object)destHash)) {
            this.log.debug("Not adding local destination to bucket.");
            return;
        }
        this.log.debug("Adding/updating peer: Hash = " + destHash);
        KademliaPeer removedOrNotAdded = this.sBucket.addOrUpdate(peer);
        if (removedOrNotAdded == null) {
            this.getKBucket(destHash).remove((Destination)peer);
        } else {
            this.addToKBucket(removedOrNotAdded);
        }
        this.logBucketStats();
    }

    private void addToKBucket(KademliaPeer peer) {
        int bucketIndex = this.getBucketIndex(peer.calculateHash());
        KBucket bucket = (KBucket)this.kBuckets.get(bucketIndex);
        if (bucket.shouldSplit((Destination)peer)) {
            KBucket newBucket = bucket.split();
            this.kBuckets.add(bucketIndex + 1, newBucket);
            while (newBucket.isEmpty() || bucket.isEmpty()) {
                if (newBucket.isEmpty()) {
                    newBucket = bucket.split();
                    this.kBuckets.add(bucketIndex + 1, newBucket);
                    continue;
                }
                bucket = newBucket;
                newBucket = newBucket.split();
                this.kBuckets.add(++bucketIndex + 1, newBucket);
            }
            bucket = this.getKBucket(peer.calculateHash());
        }
        bucket.addOrUpdate(peer);
    }

    public synchronized void noResponse(Destination destination) {
        KademliaPeer peer = this.getPeer(destination);
        if (peer != null) {
            peer.noResponse();
        } else {
            this.log.debug("Peer not found in buckets: " + destination.calculateHash());
        }
    }

    private void logBucketStats() {
        int numBuckets = this.kBuckets.size();
        int numPeers = this.getAllPeers().size();
        int numSiblings = this.sBucket.size();
        this.log.debug("total #peers=" + numPeers + ", #siblings=" + numSiblings + ", #buckets=" + numBuckets + " (not counting the sibling bucket)");
    }

    public void remove(Destination peer) {
        AbstractBucket bucket = this.getBucket(peer);
        if (bucket != null) {
            bucket.remove(peer);
            if (bucket instanceof SBucket) {
                this.refillSiblings();
            }
        } else {
            this.log.debug("Can't remove peer because no bucket contains it: " + peer.calculateHash().toBase64());
        }
    }

    private void refillSiblings() {
        ArrayList kPeers = new ArrayList();
        for (KBucket kBucket : this.kBuckets) {
            kPeers.addAll(kBucket.getPeers());
        }
        Collections.sort(kPeers, new PeerDistanceComparator(this.localDestinationHash));
        while (!this.sBucket.isFull() && !kPeers.isEmpty()) {
            KademliaPeer peerToMove = (KademliaPeer)kPeers.remove(0);
            int bucketIndex = this.getBucketIndex(peerToMove.getDestinationHash());
            ((KBucket)this.kBuckets.get(bucketIndex)).remove((Destination)peerToMove);
            this.sBucket.addOrUpdate(peerToMove);
        }
    }

    private int getBucketIndex(Hash key) {
        if (this.kBuckets.size() == 1) {
            return 0;
        }
        int lowIndex = 0;
        int highIndex = this.kBuckets.size() - 1;
        BigInteger keyValue = new BigInteger(1, key.getData());
        while (lowIndex < highIndex) {
            int centerIndex = (highIndex + lowIndex) / 2;
            if (keyValue.compareTo(((KBucket)this.kBuckets.get(centerIndex)).getStartId()) < 0) {
                highIndex = centerIndex - 1;
                continue;
            }
            if (keyValue.compareTo(((KBucket)this.kBuckets.get(centerIndex)).getEndId()) >= 0) {
                lowIndex = centerIndex + 1;
                continue;
            }
            return centerIndex;
        }
        return lowIndex;
    }

    public KBucket getKBucket(Hash key) {
        return (KBucket)this.kBuckets.get(this.getBucketIndex(key));
    }

    private KademliaPeer getPeer(Destination destination) {
        AbstractBucket bucket = this.getBucket(destination);
        if (bucket != null) {
            return bucket.getPeer(destination);
        }
        return null;
    }

    private AbstractBucket getBucket(Destination destination) {
        if (this.sBucket.contains(destination)) {
            return this.sBucket;
        }
        KBucket kBucket = this.getKBucket(destination.calculateHash());
        if (kBucket.contains(destination)) {
            return kBucket;
        }
        return null;
    }

    public List<Destination> getClosestPeers(Hash key, int count) {
        List peers = this.getAllUnlockedPeers();
        Collections.sort(peers, new PeerDistanceComparator(key));
        if (peers.size() < count) {
            return peers;
        }
        return peers.subList(0, count);
    }

    private synchronized List<Destination> getAllUnlockedPeers() {
        ArrayList<Destination> allPeers = new ArrayList<Destination>();
        for (KBucket bucket : this.kBuckets) {
            for (KademliaPeer peer : bucket.getPeers()) {
                if (peer.isLocked()) continue;
                allPeers.add((Destination)peer);
            }
        }
        for (KademliaPeer peer : this.sBucket.getPeers()) {
            if (peer.isLocked()) continue;
            allPeers.add((Destination)peer);
        }
        return allPeers;
    }

    public synchronized List<KademliaPeer> getAllPeers() {
        ArrayList<KademliaPeer> allPeers = new ArrayList<KademliaPeer>();
        for (KBucket bucket : this.kBuckets) {
            allPeers.addAll(bucket.getPeers());
        }
        allPeers.addAll(this.sBucket.getPeers());
        return allPeers;
    }

    int getPeerCount() {
        int count = 0;
        for (KBucket bucket : this.kBuckets) {
            count += bucket.size();
        }
        return count += this.sBucket.size();
    }

    int getUnlockedPeerCount() {
        return this.getAllUnlockedPeers().size();
    }

    DhtPeerStats getPeerStats() {
        return new KademliaPeerStats(this.sBucket, this.kBuckets, this.localDestinationHash);
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        boolean banned = false;
        KademliaPeer peer = this.getPeer(sender);
        if (peer != null) {
            if (packet.getProtocolVersion() != 2) {
                BanList.getInstance().ban((Destination)peer, "Wrong protocol version: " + packet.getProtocolVersion());
                this.remove((Destination)peer);
                banned = true;
            } else {
                BanList.getInstance().unban((Destination)peer);
            }
        }
        if (!banned) {
            this.addOrUpdate(new KademliaPeer(sender));
        }
    }

    SBucket getSBucket() {
        return this.sBucket;
    }

    @Override
    public Iterator<KBucket> iterator() {
        return this.kBuckets.iterator();
    }
}

