/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.kademlia.KademliaPeer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.i2p.data.Destination;

abstract class AbstractBucket
implements Iterable<KademliaPeer> {
    static final BigInteger MIN_HASH_VALUE = BigInteger.ZERO;
    static final BigInteger MAX_HASH_VALUE = BigInteger.ONE.shiftLeft(256).subtract(BigInteger.ONE);
    protected List<KademliaPeer> peers = Collections.synchronizedList(new ArrayList());
    protected int capacity;

    public AbstractBucket(int capacity) {
        this.capacity = capacity;
    }

    void remove(Destination destination) {
        this.peers.remove(destination);
    }

    Collection<KademliaPeer> getPeers() {
        return this.peers;
    }

    protected KademliaPeer getPeer(Destination destination) {
        int index = this.getPeerIndex(destination);
        if (index >= 0) {
            return (KademliaPeer)this.peers.get(index);
        }
        return null;
    }

    protected int getPeerIndex(Destination destination) {
        return this.peers.indexOf(destination);
    }

    boolean contains(Destination destination) {
        return this.getPeer(destination) != null;
    }

    boolean isFull() {
        return this.size() >= this.capacity;
    }

    boolean isEmpty() {
        return this.peers.isEmpty();
    }

    int size() {
        return this.peers.size();
    }

    @Override
    public Iterator<KademliaPeer> iterator() {
        return this.peers.iterator();
    }
}

