/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network;

import com.nettgryppa.security.HashCash;
import i2p.bote.UniqueId;
import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PacketBatch;
import i2p.bote.network.PacketBatchItem;
import i2p.bote.network.PacketListener;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.EmptyResponse;
import i2p.bote.packet.RelayPacket;
import i2p.bote.packet.RelayRequest;
import i2p.bote.packet.ResponsePacket;
import i2p.bote.packet.StatusCode;
import i2p.bote.service.I2PBoteThread;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.data.Destination;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class I2PSendQueue
extends I2PBoteThread
implements PacketListener {
    private Log log = new Log(I2PSendQueue.class);
    private I2PSession i2pSession;
    private PacketQueue packetQueue;
    private Set<PacketBatch> runningBatches;
    private int maxBandwidth;

    public I2PSendQueue(I2PSession i2pSession, I2PPacketDispatcher i2pReceiver) {
        super("I2PSendQueue");
        this.i2pSession = i2pSession;
        i2pReceiver.addPacketListener((PacketListener)this);
        this.packetQueue = new PacketQueue(this);
        this.runningBatches = new ConcurrentHashSet();
    }

    public CountDownLatch send(CommunicationPacket packet, Destination destination) {
        return this.send(packet, destination, 0L);
    }

    public CountDownLatch send(CommunicationPacket packet, Destination destination, long earliestSendTime) {
        ScheduledPacket scheduledPacket = new ScheduledPacket(packet, destination, earliestSendTime);
        this.packetQueue.add(scheduledPacket);
        return scheduledPacket.getSentLatch();
    }

    public void sendRelayRequest(RelayPacket relayPacket, HashCash hashCash, long earliestSendTime) {
        RelayRequest relayRequest = new RelayRequest(hashCash, (DataPacket)relayPacket);
        ScheduledPacket scheduledPacket = new ScheduledPacket((CommunicationPacket)relayRequest, relayPacket.getNextDestination(), earliestSendTime);
        this.packetQueue.add(scheduledPacket);
    }

    public void sendResponse(DataPacket packet, Destination destination, UniqueId requestPacketId) {
        this.sendResponse(packet, destination, StatusCode.OK, requestPacketId);
    }

    public void sendResponse(DataPacket packet, Destination destination, StatusCode statusCode, UniqueId requestPacketId) {
        this.send((CommunicationPacket)new ResponsePacket(packet, statusCode, requestPacketId), destination);
    }

    public void send(PacketBatch batch) {
        this.log.debug("Adding a batch containing " + batch.getPacketCount() + " packets.");
        this.runningBatches.add(batch);
        batch.initializeSentSignal();
        for (PacketBatchItem batchItem : batch) {
            ScheduledPacket scheduledPacket = new ScheduledPacket(batchItem.getPacket(), batchItem.getDestination(), 0L, batch);
            this.packetQueue.add(scheduledPacket);
        }
    }

    public void remove(PacketBatch batch) {
        this.runningBatches.remove(batch);
    }

    public void setMaxBandwidth(int maxBandwidth) {
        this.maxBandwidth = maxBandwidth;
    }

    public int getMaxBandwidth() {
        return this.maxBandwidth;
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        if (packet instanceof ResponsePacket) {
            this.log.debug("Response Packet received: Packet Id = " + packet.getPacketId() + " Sender = " + sender.calculateHash());
            UniqueId packetId = packet.getPacketId();
            for (PacketBatch batch : this.runningBatches) {
                if (!batch.contains(packetId)) continue;
                DataPacket payload = ((ResponsePacket)packet).getPayload();
                if (payload != null) {
                    batch.addResponse(sender, payload);
                    continue;
                }
                batch.addResponse(sender, (DataPacket)new EmptyResponse());
            }
        }
    }

    public void run() {
        I2PDatagramMaker datagramMaker = new I2PDatagramMaker(this.i2pSession);
        while (!this.shutdownRequested() || !this.packetQueue.isEmpty()) {
            PacketBatch batch;
            ScheduledPacket scheduledPacket;
            try {
                scheduledPacket = this.packetQueue.take();
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted while waiting for new packets.", (Throwable)e);
                break;
            }
            if (this.shutdownRequested() && scheduledPacket == null) break;
            CommunicationPacket i2pBotePacket = scheduledPacket.data;
            if (this.maxBandwidth > 0) {
                int packetSizeBits = i2pBotePacket.getSize() * 8;
                int maxBWBitsPerSecond = this.maxBandwidth * 1024;
                long waitTimeMsecs = 1000L * (long)packetSizeBits / (long)maxBWBitsPerSecond;
                if (System.currentTimeMillis() + waitTimeMsecs < scheduledPacket.earliestSendTime) {
                    waitTimeMsecs = scheduledPacket.earliestSendTime;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(waitTimeMsecs);
                }
                catch (InterruptedException e) {
                    this.log.warn("Interrupted while waiting to send packet.", (Throwable)e);
                }
            }
            boolean isBatchPacket = (batch = scheduledPacket.batch) != null;
            this.log.debug("Sending " + (isBatchPacket ? "" : "non-") + "batch packet: [" + i2pBotePacket + "] to peer: " + scheduledPacket.destination.calculateHash());
            byte[] replyableDatagram = datagramMaker.makeI2PDatagram(i2pBotePacket.toByteArray());
            try {
                this.i2pSession.sendMessage(scheduledPacket.destination, replyableDatagram);
                scheduledPacket.data.setSentTime(System.currentTimeMillis());
                if (isBatchPacket) {
                    batch.decrementSentLatch();
                }
                scheduledPacket.decrementSentLatch();
                this.log.debug("Packet of type " + scheduledPacket.data.getClass().getSimpleName() + " sent. Send queue length is now " + this.packetQueue.size());
                if (!isBatchPacket) continue;
                this.log.debug("  Batch has " + batch.getPacketCount() + " packets total, " + batch.getUnsentPacketCount() + " waiting to be sent.");
            }
            catch (I2PSessionException sessExc) {
                this.log.error("Can't send packet.", (Throwable)sessExc);
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException intrExc) {
                    this.log.error("Interrupted while sleeping after a send error.", (Throwable)intrExc);
                }
            }
        }
        this.log.info("I2PSendQueue exiting.");
    }

    static /* synthetic */ Log access$000(I2PSendQueue x0) {
        return x0.log;
    }
}

