/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network;

import i2p.bote.Util;
import i2p.bote.email.EmailIdentity;
import i2p.bote.folder.IncompleteEmailFolder;
import i2p.bote.network.CheckEmailTask;
import i2p.bote.network.DHT;
import i2p.bote.network.DhtResults;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PeerManager;
import i2p.bote.packet.IndexPacket;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public class CheckEmailTask
implements Callable<Boolean> {
    public static final int THREAD_STACK_SIZE = 262144;
    private static final int MAX_THREADS = 50;
    private static final ThreadFactory EMAIL_PACKET_TASK_THREAD_FACTORY = Util.createThreadFactory((String)"EmailPktTask", (int)262144);
    private Log log = new Log(CheckEmailTask.class);
    private EmailIdentity identity;
    private DHT dht;
    private PeerManager peerManager;
    private I2PSendQueue sendQueue;
    private IncompleteEmailFolder incompleteEmailFolder;
    private I2PAppContext appContext;

    public CheckEmailTask(EmailIdentity identity, DHT dht, PeerManager peerManager, I2PSendQueue sendQueue, IncompleteEmailFolder incompleteEmailFolder, I2PAppContext appContext) {
        this.identity = identity;
        this.dht = dht;
        this.peerManager = peerManager;
        this.sendQueue = sendQueue;
        this.incompleteEmailFolder = incompleteEmailFolder;
        this.appContext = appContext;
    }

    @Override
    public Boolean call() {
        DhtResults indexPacketResults = this.dht.findAll(this.identity.getHash(), IndexPacket.class);
        if (indexPacketResults.isEmpty()) {
            return false;
        }
        Collection emailPacketKeys = this.findEmailPacketKeys(indexPacketResults.getPackets());
        ArrayList results = new ArrayList();
        ExecutorService executor = Executors.newFixedThreadPool(50, EMAIL_PACKET_TASK_THREAD_FACTORY);
        for (Hash emailPacketKey : emailPacketKeys) {
            Future result = executor.submit(new EmailPacketTask(this, emailPacketKey, this.identity.getHash(), indexPacketResults.getPeers()));
            results.add(result);
        }
        executor.shutdown();
        boolean newEmail = false;
        for (Future result : results) {
            try {
                if (!((Boolean)result.get()).booleanValue()) continue;
                newEmail = true;
            }
            catch (ExecutionException e) {
                this.log.error("Can't retrieve email packet.", (Throwable)e);
            }
            catch (InterruptedException e) {
                this.log.error("Interrupted while checking for mail.", (Throwable)e);
            }
        }
        return newEmail;
    }

    private Collection<Hash> findEmailPacketKeys(Collection<DhtStorablePacket> indexPacketResults) {
        this.log.debug("Querying the DHT for index packets with key " + this.identity.getHash());
        ArrayList<IndexPacket> indexPackets = new ArrayList<IndexPacket>();
        for (DhtStorablePacket packet : indexPacketResults) {
            if (packet instanceof IndexPacket) {
                indexPackets.add((IndexPacket)packet);
                continue;
            }
            this.log.error("DHT returned packet of class " + packet.getClass().getSimpleName() + ", expected IndexPacket.");
        }
        IndexPacket mergedPacket = new IndexPacket(indexPackets);
        this.log.debug("Found " + mergedPacket.getDhtKeys().size() + " Email Packet keys.");
        return mergedPacket.getDhtKeys();
    }

    static /* synthetic */ DHT access$000(CheckEmailTask x0) {
        return x0.dht;
    }

    static /* synthetic */ EmailIdentity access$100(CheckEmailTask x0) {
        return x0.identity;
    }

    static /* synthetic */ I2PAppContext access$200(CheckEmailTask x0) {
        return x0.appContext;
    }

    static /* synthetic */ IncompleteEmailFolder access$300(CheckEmailTask x0) {
        return x0.incompleteEmailFolder;
    }

    static /* synthetic */ Log access$400(CheckEmailTask x0) {
        return x0.log;
    }

    static /* synthetic */ I2PSendQueue access$500(CheckEmailTask x0) {
        return x0.sendQueue;
    }
}

