/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.UniqueId;
import i2p.bote.folder.DhtPacketFolder;
import i2p.bote.network.PacketListener;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.IndexPacket;
import i2p.bote.packet.IndexPacketDeleteRequest;
import i2p.bote.packet.MalformedDataPacketException;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.File;
import java.util.Set;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public class IndexPacketFolder
extends DhtPacketFolder<IndexPacket>
implements PacketListener {
    private static final String DEL_FILE_PREFIX = "DEL_";
    private final Log log = new Log(IndexPacketFolder.class);

    public IndexPacketFolder(File storageDir) {
        super(storageDir);
    }

    public void store(DhtStorablePacket packetToStore) {
        if (!(packetToStore instanceof IndexPacket)) {
            throw new IllegalArgumentException("This class only stores packets of type " + IndexPacket.class.getSimpleName() + ".");
        }
        IndexPacket indexPacketToStore = (IndexPacket)packetToStore;
        DhtStorablePacket existingPacket = this.retrieve(packetToStore.getDhtKey());
        if (existingPacket instanceof IndexPacket && (packetToStore = new IndexPacket(new IndexPacket[]{indexPacketToStore, (IndexPacket)existingPacket})).isTooBig()) {
            this.log.error("After merging, IndexPacket is too big for a datagram: size=" + packetToStore.getSize());
        }
        super.store(packetToStore);
    }

    public void delete(Hash dhtKey) {
        throw new UnsupportedOperationException("Index packets are never deleted. Use remove(Hash, Hash) to remove an entry from an index packet file.");
    }

    public void remove(IndexPacket indexPacket, Hash emailPacketKey) {
        this.log.debug("Removing DHT key " + emailPacketKey + " from Index Packet for Email Dest " + indexPacket.getDhtKey());
        UniqueId deletionKey = indexPacket.getDeletionKey(emailPacketKey);
        if (deletionKey == null) {
            this.log.debug("DHT key " + emailPacketKey + " not found in index packet " + indexPacket);
        } else {
            indexPacket.remove(emailPacketKey);
            this.addToDeletedPackets(indexPacket, emailPacketKey, deletionKey);
        }
        super.store((DhtStorablePacket)indexPacket);
    }

    private void addToDeletedPackets(IndexPacket indexPacket, Hash dhtKey, UniqueId deletionKey) {
        DhtStorablePacket delListPacket;
        String delFileName = DEL_FILE_PREFIX + this.getFilename((DhtStorablePacket)indexPacket);
        File delFile = new File(this.storageDir, delFileName);
        if (!delFile.exists()) {
            delListPacket = new IndexPacket(new IndexPacket[]{indexPacket});
        } else {
            try {
                delListPacket = DhtStorablePacket.createPacket((File)delFile);
            }
            catch (MalformedDataPacketException e) {
                this.log.error("Cannot read Delete List Packet, creating a new one: <" + delFile.getAbsolutePath() + ">", (Throwable)e);
                delListPacket = new IndexPacket(new IndexPacket[]{indexPacket});
            }
            if (!(delListPacket instanceof IndexPacket)) {
                this.log.error("Not an Index Packet file: <" + delFile + ">");
                return;
            }
        }
        ((IndexPacket)delListPacket).put(dhtKey, deletionKey);
        this.add((DataPacket)delListPacket, delFileName);
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        if (packet instanceof IndexPacketDeleteRequest) {
            IndexPacketDeleteRequest delRequest = (IndexPacketDeleteRequest)packet;
            this.log.debug("IndexPacketDeleteRequest received. #entries=" + delRequest.getNumEntries());
            Hash dhtKey = delRequest.getEmailDestHash();
            DhtStorablePacket storedPacket = this.retrieve(dhtKey);
            if (storedPacket instanceof IndexPacket) {
                IndexPacket indexPacket = (IndexPacket)storedPacket;
                Set keysToDelete = delRequest.getDhtKeys();
                for (Hash keyToDelete : keysToDelete) {
                    UniqueId deletionKeyFromRequest = delRequest.getDeletionKey(keyToDelete);
                    UniqueId storedDeletionKey = indexPacket.getDeletionKey(keyToDelete);
                    if (storedDeletionKey == null) {
                        this.log.debug("Deletion key " + deletionKeyFromRequest + " from IndexPacketDeleteRequest not found in index packet for destination " + dhtKey);
                        continue;
                    }
                    if (storedDeletionKey.equals((Object)deletionKeyFromRequest)) {
                        this.remove(indexPacket, keyToDelete);
                        continue;
                    }
                    this.log.debug("Deletion key in IndexPacketDeleteRequest does not match. Should be: <" + storedDeletionKey + ">, is <" + deletionKeyFromRequest + ">");
                }
            } else {
                this.log.debug("IndexPacket expected for DHT key <" + dhtKey + ">, found " + storedPacket.getClass().getSimpleName());
            }
        }
    }
}

