/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.email;

import com.nettgryppa.security.HashCash;
import i2p.bote.UniqueId;
import i2p.bote.packet.UnencryptedEmailPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import net.i2p.util.Log;

public class Email
extends MimeMessage {
    private static final int MAX_BYTES_PER_PACKET = 30720;
    private static final String[] HEADER_WHITELIST = new String[]{"From", "Sender", "To", "CC", "BCC", "Reply-To", "Subject", "Date", "MIME-Version", "Content-Type", "Content-Transfer-Encoding", "In-Reply-To", "X-HashCash", "X-Priority"};
    private static Log log = new Log(Email.class);
    private UniqueId messageId = new UniqueId();
    private boolean isNew = true;

    public Email() {
        super(Session.getDefaultInstance((Properties)new Properties()));
    }

    public Email(File file) throws FileNotFoundException, MessagingException {
        this((InputStream)new FileInputStream(file));
    }

    private Email(InputStream inputStream) throws MessagingException {
        super(Session.getDefaultInstance((Properties)new Properties()), inputStream);
    }

    public Email(byte[] bytes) throws MessagingException {
        super(Session.getDefaultInstance((Properties)new Properties()), (InputStream)new ByteArrayInputStream(bytes));
    }

    public void setHashCash(HashCash hashCash) throws MessagingException {
        this.setHeader("X-HashCash", hashCash.toString());
    }

    public void updateHeaders() {
        try {
            super.updateHeaders();
            this.scrubHeaders();
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT+0"));
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy kk:mm:ss +0000", Locale.ENGLISH);
            this.setHeader("Date", formatter.format(calendar.getTime()));
        }
        catch (MessagingException e) {
            log.error("Cannot set mail headers.", (Throwable)e);
        }
    }

    private Email removeBCCs(String recipient) throws MessagingException, IOException {
        Email newEmail = new Email();
        newEmail.setContent(this.getContent(), this.getDataHandler().getContentType());
        newEmail.headers = new InternetHeaders();
        ArrayList<Header> headers = Collections.list(this.getAllHeaders());
        for (Header header : headers) {
            if ("BCC".equals(header.getName()) && recipient.equals(header.getValue())) continue;
            newEmail.addHeader(header.getName(), header.getValue());
        }
        return newEmail;
    }

    private void scrubHeaders() throws MessagingException {
        ArrayList<Header> nonMatchingHeaders = Collections.list(this.getNonMatchingHeaders(HEADER_WHITELIST));
        for (Header header : nonMatchingHeaders) {
            log.debug("Removing all instances of non-whitelisted header <" + header.getName() + ">");
            this.removeHeader(header.getName());
        }
    }

    public void setMessageID(String messageIdString) {
        this.messageId = new UniqueId(messageIdString);
    }

    public void setMessageID(UniqueId messageId) {
        this.messageId = messageId;
    }

    public String getMessageID() {
        return this.messageId.toBase64();
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getText() {
        try {
            return this.getContent().toString();
        }
        catch (Exception e) {
            String errorMsg = "Error reading email content.";
            log.error(errorMsg, (Throwable)e);
            return errorMsg;
        }
    }

    public Collection<UnencryptedEmailPacket> createEmailPackets(String bccToKeep) {
        int blockSize;
        ArrayList<UnencryptedEmailPacket> packets = new ArrayList<UnencryptedEmailPacket>();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.saveChanges();
            if (bccToKeep == null) {
                this.writeTo((OutputStream)outputStream);
            } else {
                this.removeBCCs(bccToKeep).writeTo((OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
            return packets;
        }
        catch (MessagingException e) {
            log.error("Can't remove BCC headers.", (Throwable)e);
            return packets;
        }
        byte[] emailArray = outputStream.toByteArray();
        int numFragments = (emailArray.length + 30720 - 1) / 30720;
        int fragmentIndex = 0;
        int blockStart = 0;
        while ((blockSize = Math.min(emailArray.length - blockStart, 30720)) > 0) {
            byte[] block = new byte[blockSize];
            System.arraycopy(emailArray, blockStart, block, 0, blockSize);
            UniqueId deletionKey = new UniqueId();
            UnencryptedEmailPacket packet = new UnencryptedEmailPacket(this.messageId, fragmentIndex, numFragments, block, deletionKey);
            packets.add(packet);
            ++fragmentIndex;
            blockStart += blockSize;
        }
        return packets;
    }
}

