/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.addressbook;

import i2p.bote.addressbook.Contact;
import i2p.bote.email.EmailDestination;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.i2p.data.DataFormatException;
import net.i2p.util.Log;

public class AddressBook
implements Iterable<Contact> {
    private Log log = new Log(AddressBook.class);
    private File addressFile;
    private List<Contact> contacts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressBook(File addressFile) {
        this.addressFile = addressFile;
        this.contacts = Collections.synchronizedList(new ArrayList());
        if (!addressFile.exists()) {
            this.log.debug("Address file does not exist: <" + addressFile.getAbsolutePath() + ">");
            return;
        }
        this.log.debug("Reading address book from <" + addressFile.getAbsolutePath() + ">");
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new FileReader(addressFile));
            while ((line = input.readLine()) != null) {
                String[] fields = line.split("\\t", 2);
                try {
                    EmailDestination destination = new EmailDestination(fields[0]);
                    String name = null;
                    if (fields.length > 1) {
                        name = fields[1];
                    }
                    this.contacts.add(new Contact(destination, name));
                }
                catch (DataFormatException e) {
                    this.log.error("Not a valid Email Destination: <" + fields[0] + ">");
                }
            }
        }
        catch (IOException e) {
            this.log.error("Can't read address book.", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.log.error("Error closing input stream.", (Throwable)e);
                }
            }
        }
    }

    public void save() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.addressFile));
        try {
            for (Contact contact : this.contacts) {
                writer.write(contact.toBase64());
                writer.write("\t");
                writer.write(contact.getName());
                writer.newLine();
            }
        }
        catch (IOException e) {
            this.log.error("Can't save address book to file <" + this.addressFile.getAbsolutePath() + ">.", (Throwable)e);
            throw e;
        }
        finally {
            writer.close();
        }
    }

    public void add(Contact contact) {
        this.contacts.add(contact);
    }

    public void remove(String destination) {
        Contact contact = this.get(destination);
        if (contact != null) {
            this.contacts.remove(contact);
        }
    }

    public Contact get(int i) {
        return (Contact)this.contacts.get(i);
    }

    public Contact get(String destination) {
        if (destination == null || destination.isEmpty()) {
            return null;
        }
        for (Contact contact : this.contacts) {
            if (!destination.equals(contact.toBase64())) continue;
            return contact;
        }
        return null;
    }

    public Collection<Contact> getAll() {
        return this.contacts;
    }

    public int size() {
        return this.contacts.size();
    }

    @Override
    public Iterator<Contact> iterator() {
        return this.contacts.iterator();
    }
}

