/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.i2p.data.Base64;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class UniqueId
implements Comparable<UniqueId> {
    public static final byte LENGTH = 32;
    private Log log = new Log(UniqueId.class);
    protected byte[] bytes;

    public UniqueId() {
        this.bytes = new byte[32];
        for (int i = 0; i < 32; ++i) {
            this.bytes[i] = (byte)RandomSource.getInstance().nextInt(256);
        }
    }

    public UniqueId(byte[] bytes, int offset) {
        this.bytes = new byte[32];
        System.arraycopy(bytes, offset, this.bytes, 0, 32);
    }

    public UniqueId(ByteBuffer buffer) {
        this.bytes = new byte[32];
        buffer.get(this.bytes);
    }

    public UniqueId(InputStream inputStream) throws IOException {
        this.bytes = new byte[32];
        if (inputStream.read(this.bytes) < 0) {
            this.log.error("Cannot read 32 bytes: Unexpected end of stream.");
        }
    }

    public UniqueId(String base64) {
        this.bytes = Base64.decode((String)base64);
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public String toBase64() {
        return Base64.encode((byte[])this.bytes);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes);
    }

    @Override
    public int compareTo(UniqueId otherPacketId) {
        return new BigInteger(1, this.bytes).compareTo(new BigInteger(1, otherPacketId.bytes));
    }

    public String toString() {
        return Base64.encode((byte[])this.bytes);
    }

    public boolean equals(Object anotherObject) {
        if (!(anotherObject instanceof UniqueId)) {
            return false;
        }
        UniqueId otherPacketId = (UniqueId)anotherObject;
        return Arrays.equals(this.bytes, otherPacketId.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

