/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.Log;

public class SendMessageExpiresMessage
extends SendMessageMessage {
    private static final Log _log = new Log(SendMessageExpiresMessage.class);
    public static final int MESSAGE_TYPE = 36;
    private SessionId _sessionId;
    private Destination _destination;
    private Payload _payload;
    private Date _expiration;

    public SendMessageExpiresMessage() {
        this.setExpiration(null);
    }

    public Date getExpiration() {
        return this._expiration;
    }

    public void setExpiration(Date d) {
        this._expiration = d;
    }

    public void readMessage(InputStream in, int length, int type) throws I2CPMessageException, IOException {
        super.readMessage(in, length, type);
        try {
            this._expiration = DataHelper.readDate(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        if (this.getSessionId() == null || this.getDestination() == null || this.getPayload() == null || this.getNonce() <= 0L || this._expiration == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        int len = 2 + this.getDestination().size() + this.getPayload().getSize() + 4 + 4 + 8;
        try {
            DataHelper.writeLong(out, 4, len);
            DataHelper.writeLong(out, 1, this.getType());
            this.getSessionId().writeBytes(out);
            this.getDestination().writeBytes(out);
            this.getPayload().writeBytes(out);
            DataHelper.writeLong(out, 4, this.getNonce());
            DataHelper.writeDate(out, this._expiration);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing the msg", dfe);
        }
    }

    public int getType() {
        return 36;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SendMessageExpiresMessage) {
            SendMessageExpiresMessage msg = (SendMessageExpiresMessage)object;
            return super.equals(object) && DataHelper.eq(this.getExpiration(), msg.getExpiration());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[SendMessageMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tNonce: ").append(this.getNonce());
        buf.append("\n\tDestination: ").append(this.getDestination());
        buf.append("\n\tExpiration: ").append(this.getExpiration());
        buf.append("\n\tPayload: ").append(this.getPayload());
        buf.append("]");
        return buf.toString();
    }
}

