/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.Log;

public class ReconfigureSessionMessage
extends I2CPMessageImpl {
    private static final Log _log = new Log(ReconfigureSessionMessage.class);
    public static final int MESSAGE_TYPE = 2;
    private SessionId _sessionId = null;
    private SessionConfig _sessionConfig = null;

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public SessionConfig getSessionConfig() {
        return this._sessionConfig;
    }

    public void setSessionConfig(SessionConfig config) {
        this._sessionConfig = config;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            this._sessionConfig = new SessionConfig();
            this._sessionConfig.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null || this._sessionConfig == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        try {
            this._sessionId.writeBytes(os);
            this._sessionConfig.writeBytes(os);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ReconfigureSessionMessage) {
            ReconfigureSessionMessage msg = (ReconfigureSessionMessage)object;
            return DataHelper.eq(this.getSessionId(), msg.getSessionId()) && DataHelper.eq(this.getSessionConfig(), msg.getSessionConfig());
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[ReconfigureSessionMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tSessionConfig: ").append(this.getSessionConfig());
        buf.append("]");
        return buf.toString();
    }
}

