/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class TunnelId
extends DataStructureImpl {
    private long _tunnelId;
    private int _type;
    public static final long MAX_ID_VALUE = 0xFFFFFFFEL;
    public static final int TYPE_UNSPECIFIED = 0;
    public static final int TYPE_INBOUND = 1;
    public static final int TYPE_OUTBOUND = 2;
    public static final int TYPE_PARTICIPANT = 3;
    public static final TunnelId INVALID = new TunnelId(0L, true);

    public TunnelId() {
        this._tunnelId = -1L;
        this._type = 0;
    }

    public TunnelId(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("wtf, tunnelId " + id);
        }
        this._tunnelId = id;
        this._type = 0;
    }

    public TunnelId(long id, int type) {
        if (id <= 0L) {
            throw new IllegalArgumentException("wtf, tunnelId " + id);
        }
        this._tunnelId = id;
        this._type = type;
    }

    private TunnelId(long id, boolean forceInvalid) {
        this._tunnelId = id;
    }

    public long getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(long id) {
        this._tunnelId = id;
        if (id <= 0L) {
            throw new IllegalArgumentException("wtf, tunnelId " + id);
        }
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._tunnelId = DataHelper.readLong(in, 4);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._tunnelId < 0L) {
            throw new DataFormatException("Invalid tunnel ID: " + this._tunnelId);
        }
        DataHelper.writeLong(out, 4, this._tunnelId);
    }

    public int writeBytes(byte[] target, int offset) throws DataFormatException {
        if (this._tunnelId < 0L) {
            throw new DataFormatException("Invalid tunnel ID: " + this._tunnelId);
        }
        DataHelper.toLong(target, offset, 4, this._tunnelId);
        return 4;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TunnelId)) {
            return false;
        }
        return this.getTunnelId() == ((TunnelId)obj).getTunnelId();
    }

    public int hashCode() {
        return (int)this.getTunnelId();
    }

    public String toString() {
        return String.valueOf(this.getTunnelId());
    }
}

