/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class RouterAddress
extends DataStructureImpl {
    private int _cost;
    private Date _expiration;
    private String _transportStyle;
    private Properties _options;

    public RouterAddress() {
        this.setCost(-1);
        this.setExpiration(null);
        this.setTransportStyle(null);
        this.setOptions(null);
    }

    public int getCost() {
        return this._cost;
    }

    public void setCost(int cost) {
        this._cost = cost;
    }

    public Date getExpiration() {
        return this._expiration;
    }

    public void setExpiration(Date expiration) {
        this._expiration = expiration;
    }

    public String getTransportStyle() {
        return this._transportStyle;
    }

    public void setTransportStyle(String transportStyle) {
        this._transportStyle = transportStyle;
    }

    public Properties getOptions() {
        return this._options;
    }

    public void setOptions(Properties options) {
        this._options = options;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._cost = (int)DataHelper.readLong(in, 1);
        this._expiration = DataHelper.readDate(in);
        this._transportStyle = DataHelper.readString(in);
        this._options = DataHelper.readProperties(in);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._cost < 0 || this._transportStyle == null || this._options == null) {
            throw new DataFormatException("Not enough data to write a router address");
        }
        DataHelper.writeLong(out, 1, this._cost);
        DataHelper.writeDate(out, this._expiration);
        DataHelper.writeString(out, this._transportStyle);
        DataHelper.writeProperties(out, this._options);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RouterAddress)) {
            return false;
        }
        RouterAddress addr = (RouterAddress)object;
        return DataHelper.eq(this.getCost(), addr.getCost()) && DataHelper.eq(this.getExpiration(), addr.getExpiration()) && DataHelper.eq(this.getOptions(), addr.getOptions()) && DataHelper.eq(this.getTransportStyle(), addr.getTransportStyle());
    }

    public int hashCode() {
        return DataHelper.hashCode(this.getTransportStyle());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[RouterAddress: ");
        buf.append("\n\tTransportStyle: ").append(this.getTransportStyle());
        buf.append("\n\tCost: ").append(this.getCost());
        buf.append("\n\tExpiration: ").append(this.getExpiration());
        buf.append("\n\tOptions: #: ").append(this.getOptions().size());
        for (String string : this.getOptions().keySet()) {
            String val = this.getOptions().getProperty(string);
            buf.append("\n\t\t[").append(string).append("] = [").append(val).append("]");
        }
        buf.append("]");
        return buf.toString();
    }
}

