/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.crypto.KeyGenerator;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.PublicKey;

public class PrivateKey
extends DataStructureImpl {
    private byte[] _data;
    public static final int KEYSIZE_BYTES = 256;

    public PrivateKey() {
        this.setData(null);
    }

    public PrivateKey(byte[] data) {
        this.setData(data);
    }

    public PrivateKey(String base64Data) throws DataFormatException {
        this();
        this.fromBase64(base64Data);
    }

    public byte[] getData() {
        return this._data;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._data = new byte[256];
        int read = this.read(in, this._data);
        if (read != 256) {
            throw new DataFormatException("Not enough bytes to read the private key");
        }
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._data == null) {
            throw new DataFormatException("No data in the private key to write out");
        }
        if (this._data.length != 256) {
            throw new DataFormatException("Invalid size of data in the private key [" + this._data.length + "]");
        }
        out.write(this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PrivateKey)) {
            return false;
        }
        return DataHelper.eq(this._data, ((PrivateKey)obj)._data);
    }

    public int hashCode() {
        int rv = 0;
        if (this._data != null) {
            for (int i = 0; i < 4; ++i) {
                rv ^= this._data[i] << i * 8;
            }
        }
        return rv;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[PrivateKey: ");
        if (this._data == null) {
            buf.append("null key");
        } else {
            buf.append("size: ").append(this._data.length);
        }
        buf.append("]");
        return buf.toString();
    }

    public PublicKey toPublic() {
        return KeyGenerator.getPublicKey(this);
    }
}

