/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class Certificate
extends DataStructureImpl {
    private int _type;
    private byte[] _payload;
    public static final int CERTIFICATE_TYPE_NULL = 0;
    public static final int CERTIFICATE_TYPE_HASHCASH = 1;
    public static final int CERTIFICATE_TYPE_HIDDEN = 2;
    public static final int CERTIFICATE_TYPE_SIGNED = 3;
    public static final int CERTIFICATE_LENGTH_SIGNED_WITH_HASH = 72;
    public static final int CERTIFICATE_TYPE_MULTIPLE = 4;

    public Certificate() {
        this._type = 0;
        this._payload = null;
    }

    public Certificate(int type, byte[] payload) {
        this._type = type;
        this._payload = payload;
    }

    public int getCertificateType() {
        return this._type;
    }

    public void setCertificateType(int type) {
        this._type = type;
    }

    public byte[] getPayload() {
        return this._payload;
    }

    public void setPayload(byte[] payload) {
        this._payload = payload;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._type = (int)DataHelper.readLong(in, 1);
        int length = (int)DataHelper.readLong(in, 2);
        if (length > 0) {
            this._payload = new byte[length];
            int read = this.read(in, this._payload);
            if (read != length) {
                throw new DataFormatException("Not enough bytes for the payload (read: " + read + " length: " + length + ")");
            }
        }
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._type < 0) {
            throw new DataFormatException("Invalid certificate type: " + this._type);
        }
        DataHelper.writeLong(out, 1, this._type);
        if (this._payload != null) {
            DataHelper.writeLong(out, 2, this._payload.length);
            out.write(this._payload);
        } else {
            DataHelper.writeLong(out, 2, 0L);
        }
    }

    public int writeBytes(byte[] target, int offset) {
        int cur = offset;
        DataHelper.toLong(target, cur, 1, this._type);
        ++cur;
        if (this._payload != null) {
            DataHelper.toLong(target, cur, 2, this._payload.length);
            System.arraycopy(this._payload, 0, target, cur += 2, this._payload.length);
            cur += this._payload.length;
        } else {
            DataHelper.toLong(target, cur, 2, 0L);
            cur += 2;
        }
        return cur - offset;
    }

    public int readBytes(byte[] source, int offset) throws DataFormatException {
        if (source == null) {
            throw new DataFormatException("Cert is null");
        }
        if (source.length < offset + 3) {
            throw new DataFormatException("Cert is too small [" + source.length + " off=" + offset + "]");
        }
        int cur = offset;
        this._type = (int)DataHelper.fromLong(source, cur, 1);
        int length = (int)DataHelper.fromLong(source, ++cur, 2);
        cur += 2;
        if (length > 0) {
            if (length + cur > source.length) {
                throw new DataFormatException("Payload on the certificate is insufficient (len=" + source.length + " off=" + offset + " cur=" + cur + " payloadLen=" + length);
            }
            this._payload = new byte[length];
            System.arraycopy(source, cur, this._payload, 0, length);
            cur += length;
        }
        return cur - offset;
    }

    public int size() {
        return 3 + (this._payload != null ? this._payload.length : 0);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Certificate)) {
            return false;
        }
        Certificate cert = (Certificate)object;
        return this.getCertificateType() == cert.getCertificateType() && DataHelper.eq(this.getPayload(), cert.getPayload());
    }

    public int hashCode() {
        return this.getCertificateType() + DataHelper.hashCode(this.getPayload());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[Certificate: type: ");
        if (this.getCertificateType() == 0) {
            buf.append("Null certificate");
        } else if (this.getCertificateType() == 1) {
            buf.append("Hashcash certificate");
        } else if (this.getCertificateType() == 2) {
            buf.append("Hidden certificate");
        } else if (this.getCertificateType() == 3) {
            buf.append("Signed certificate");
        } else {
            buf.append("Unknown certificate type (").append(this.getCertificateType()).append(")");
        }
        if (this._payload == null) {
            buf.append(" null payload");
        } else {
            buf.append(" payload size: ").append(this._payload.length);
            if (this.getCertificateType() == 1) {
                buf.append(" Stamp: ").append(new String(this._payload));
            } else if (this.getCertificateType() == 3 && this._payload.length == 72) {
                buf.append(" Signed by hash: ").append(Base64.encode(this._payload, 40, 32));
            } else {
                int len = 32;
                if (len > this._payload.length) {
                    len = this._payload.length;
                }
                buf.append(" first ").append(len).append(" bytes: ");
                buf.append(DataHelper.toString(this._payload, len));
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

