/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.DataHelper;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientSessionKeyManager
extends SessionKeyManager {
    private Log _log;
    private final Map<PublicKey, OutboundSession> _outboundSessions;
    private final Map<SessionTag, TagSet> _inboundTagSets;
    protected I2PAppContext _context;
    private volatile boolean _alive;
    public static final long SESSION_TAG_DURATION_MS = 600000L;
    public static final long SESSION_LIFETIME_MAX_MS = 900000L;
    public static final int MAX_INBOUND_SESSION_TAGS = 500000;

    public TransientSessionKeyManager(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(TransientSessionKeyManager.class);
        this._context = context;
        this._outboundSessions = new HashMap<PublicKey, OutboundSession>(64);
        this._inboundTagSets = new HashMap<SessionTag, TagSet>(1024);
        context.statManager().createRateStat("crypto.sessionTagsExpired", "How many tags/sessions are expired?", "Encryption", new long[]{600000L, 3600000L, 10800000L});
        context.statManager().createRateStat("crypto.sessionTagsRemaining", "How many tags/sessions are remaining after a cleanup?", "Encryption", new long[]{600000L, 3600000L, 10800000L});
        this._alive = true;
        SimpleScheduler.getInstance().addEvent(new CleanupEvent(), 60000L);
    }

    private TransientSessionKeyManager() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this._alive = false;
        Map<Object, Object> map = this._inboundTagSets;
        synchronized (map) {
            this._inboundTagSets.clear();
        }
        map = this._outboundSessions;
        synchronized (map) {
            this._outboundSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<TagSet> getInboundTagSets() {
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            return new HashSet<TagSet>(this._inboundTagSets.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OutboundSession> getOutboundSessions() {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            return new HashSet<OutboundSession>(this._outboundSessions.values());
        }
    }

    @Override
    public SessionKey getCurrentKey(PublicKey target) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return null;
        }
        long now = this._context.clock().now();
        if (sess.getLastUsedDate() < now - 900000L) {
            if (this._log.shouldLog(20)) {
                this._log.info("Expiring old session key established on " + new Date(sess.getEstablishedDate()) + " but not used for " + (now - sess.getLastUsedDate()) + "ms with target " + target);
            }
            return null;
        }
        return sess.getCurrentKey();
    }

    @Override
    public void createSession(PublicKey target, SessionKey key) {
        this.createAndReturnSession(target, key);
    }

    private OutboundSession createAndReturnSession(PublicKey target, SessionKey key) {
        OutboundSession sess = new OutboundSession(target);
        sess.setCurrentKey(key);
        this.addSession(sess);
        return sess;
    }

    @Override
    public SessionTag consumeNextAvailableTag(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("No session for " + target);
            }
            return null;
        }
        if (sess.getCurrentKey().equals(key)) {
            SessionTag nxt = sess.consumeNext();
            if (this._log.shouldLog(10)) {
                this._log.debug("OB Tag consumed: " + nxt + " with: " + key);
            }
            return nxt;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Key does not match existing key, no tag");
        }
        return null;
    }

    @Override
    public int getAvailableTags(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0;
        }
        if (sess.getCurrentKey().equals(key)) {
            return sess.availableTags();
        }
        return 0;
    }

    @Override
    public long getAvailableTimeLeft(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0L;
        }
        if (sess.getCurrentKey().equals(key)) {
            long end = sess.getLastExpirationDate();
            if (end <= 0L) {
                return 0L;
            }
            return end - this._context.clock().now();
        }
        return 0L;
    }

    @Override
    public TagSetHandle tagsDelivered(PublicKey target, SessionKey key, Set<SessionTag> sessionTags) {
        OutboundSession sess;
        if (this._log.shouldLog(10) && sessionTags.size() > 0) {
            this._log.debug("Tags delivered: " + sessionTags.size() + " for key: " + key + ": " + sessionTags);
        }
        if ((sess = this.getSession(target)) == null) {
            sess = this.createAndReturnSession(target, key);
        } else {
            sess.setCurrentKey(key);
        }
        TagSet set = new TagSet(sessionTags, key, this._context.clock().now());
        sess.addTags(set);
        return set;
    }

    @Override
    public void failTags(PublicKey target) {
        this.removeSession(target);
    }

    @Override
    public void failTags(PublicKey target, SessionKey key, TagSetHandle ts) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return;
        }
        if (!key.equals(sess.getCurrentKey())) {
            return;
        }
        sess.failTags((TagSet)ts);
        if (this._log.shouldLog(10)) {
            this._log.debug("TagSet failed: " + ts);
        }
    }

    @Override
    public void tagsAcked(PublicKey target, SessionKey key, TagSetHandle ts) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return;
        }
        if (!key.equals(sess.getCurrentKey())) {
            return;
        }
        sess.ackTags((TagSet)ts);
        if (this._log.shouldLog(10)) {
            this._log.debug("TagSet acked: " + ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags) {
        int overage = 0;
        TagSet tagSet = new TagSet(sessionTags, key, this._context.clock().now());
        TagSet old = null;
        SessionTag dupTag = null;
        for (SessionTag tag : sessionTags) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Receiving tag " + tag + " for key " + key + ": tagSet: " + tagSet);
            }
            Map<SessionTag, TagSet> map = this._inboundTagSets;
            synchronized (map) {
                old = this._inboundTagSets.put(tag, tagSet);
                overage = this._inboundTagSets.size() - 500000;
                if (old != null) {
                    if (!old.getAssociatedKey().equals(tagSet.getAssociatedKey())) {
                        this._inboundTagSets.remove(tag);
                        dupTag = tag;
                        break;
                    }
                    old = null;
                }
            }
        }
        if (old != null) {
            Map<SessionTag, TagSet> map = this._inboundTagSets;
            synchronized (map) {
                for (SessionTag tag : old.getTags()) {
                    this._inboundTagSets.remove(tag);
                }
                for (SessionTag tag : sessionTags) {
                    this._inboundTagSets.remove(tag);
                }
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Multiple tags matching!  tagSet: " + tagSet + " and old tagSet: " + old + " tag: " + dupTag + "/" + dupTag);
                this._log.warn("Earlier tag set creation: " + old + ": key=" + old.getAssociatedKey());
                this._log.warn("Current tag set creation: " + tagSet + ": key=" + tagSet.getAssociatedKey());
            }
        }
        if (overage > 0) {
            this.clearExcess(overage);
        }
        if (sessionTags.size() <= 0 && this._log.shouldLog(10)) {
            this._log.debug("Received 0 tags for key " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExcess(int overage) {
        long now = this._context.clock().now();
        int old = 0;
        int large = 0;
        int absurd = 0;
        int recent = 0;
        int tags = 0;
        int toRemove = overage * 2;
        this._log.log(50, "TOO MANY SESSION TAGS! Starting cleanup, overage = " + overage);
        ArrayList<TagSet> removed = new ArrayList<TagSet>(toRemove);
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            for (TagSet set : this._inboundTagSets.values()) {
                int size = set.getTags().size();
                if (size > 1000) {
                    ++absurd;
                }
                if (size > 100) {
                    ++large;
                }
                if (now - set.getDate() > 900000L) {
                    ++old;
                } else if (now - set.getDate() < 60000L) {
                    ++recent;
                }
                if (removed.size() >= toRemove && now - set.getDate() <= 900000L) continue;
                removed.add(set);
            }
            for (int i = 0; i < removed.size(); ++i) {
                TagSet cur = (TagSet)removed.get(i);
                for (SessionTag tag : cur.getTags()) {
                    this._inboundTagSets.remove(tag);
                    ++tags;
                }
            }
        }
        if (this._log.shouldLog(50)) {
            this._log.log(50, "TOO MANY SESSION TAGS!  removing " + removed + " tag sets arbitrarily, with " + tags + " tags," + "where there are " + old + " long lasting sessions, " + recent + " ones created in the last minute, and " + large + " sessions with more than 100 tags (and " + absurd + " with more than 1000!), leaving a total of " + this._inboundTagSets.size() + " tags behind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionKey consumeTag(SessionTag tag) {
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            TagSet tagSet = this._inboundTagSets.remove(tag);
            if (tagSet == null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Cannot consume IB " + tag + " as it is not known");
                }
                return null;
            }
            tagSet.consume(tag);
            SessionKey key = tagSet.getAssociatedKey();
            if (this._log.shouldLog(10)) {
                this._log.debug("Consuming IB " + tag + " for " + key + " on: " + tagSet);
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutboundSession getSession(PublicKey target) {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            return this._outboundSessions.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(OutboundSession sess) {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            this._outboundSessions.put(sess.getTarget(), sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(PublicKey target) {
        if (target == null) {
            return;
        }
        OutboundSession session = null;
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            session = this._outboundSessions.remove(target);
        }
        if (session != null && this._log.shouldLog(30)) {
            this._log.warn("Removing session tags with " + session.availableTags() + " available for " + (session.getLastExpirationDate() - this._context.clock().now()) + "ms more", new Exception("Removed by"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int aggressiveExpire() {
        Iterator<Object> iter;
        int removed = 0;
        int remaining = 0;
        long now = this._context.clock().now();
        StringBuilder buf = null;
        if (this._log.shouldLog(10)) {
            buf = new StringBuilder(128);
            buf.append("Expiring inbound: ");
        }
        Map<Object, Object> map = this._inboundTagSets;
        synchronized (map) {
            iter = this._inboundTagSets.keySet().iterator();
            while (iter.hasNext()) {
                SessionTag tag = iter.next();
                TagSet ts = this._inboundTagSets.get(tag);
                long age = now - ts.getDate();
                if (age <= 900000L) continue;
                iter.remove();
                ++removed;
                if (buf == null) continue;
                buf.append(tag).append(" @ age ").append(DataHelper.formatDuration(age));
            }
            remaining = this._inboundTagSets.size();
        }
        this._context.statManager().addRateData("crypto.sessionTagsRemaining", remaining, 0L);
        if (buf != null && removed > 0) {
            this._log.debug(buf.toString());
        }
        map = this._outboundSessions;
        synchronized (map) {
            iter = this._outboundSessions.keySet().iterator();
            while (iter.hasNext()) {
                PublicKey key = (PublicKey)iter.next();
                OutboundSession sess = this._outboundSessions.get(key);
                removed += sess.expireTags();
                if (sess.getLastUsedDate() >= now - 450000L || sess.availableTags() > 0) continue;
                iter.remove();
                ++removed;
            }
        }
        return removed;
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h2>Inbound sessions</h2><table>");
        Set<TagSet> inbound = this.getInboundTagSets();
        HashMap inboundSets = new HashMap(inbound.size());
        for (TagSet ts : inbound) {
            if (!inboundSets.containsKey(ts.getAssociatedKey())) {
                inboundSets.put(ts.getAssociatedKey(), new HashSet());
            }
            Set sets = (Set)inboundSets.get(ts.getAssociatedKey());
            sets.add(ts);
        }
        int total = 0;
        long now = this._context.clock().now();
        for (SessionKey skey : inboundSets.keySet()) {
            TreeSet sets = new TreeSet(new TagSetComparator());
            sets.addAll((Collection)inboundSets.get(skey));
            buf.append("<tr><td><b>Session key</b>: ").append(skey.toBase64()).append("</td><td><b># Sets:</b> ").append(sets.size()).append("</td></tr><tr><td colspan=\"2\"><ul>");
            for (TagSet ts : sets) {
                int size = ts.getTags().size();
                total += size;
                buf.append("<li><b>Received:</b> ").append(DataHelper.formatDuration(now - ts.getDate())).append(" ago with ");
                buf.append(size).append(" tags remaining</li>");
            }
            buf.append("</ul></td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        buf.append("<tr><th colspan=\"2\">Total tags: ").append(total).append(" (");
        buf.append(DataHelper.formatSize(32 * total)).append("B)</th></tr>\n</table><h2><b>Outbound sessions</b></h2><table>");
        total = 0;
        Set<OutboundSession> outbound = this.getOutboundSessions();
        for (OutboundSession sess : outbound) {
            TreeSet<TagSet> sets = new TreeSet<TagSet>(new TagSetComparator());
            sets.addAll(sess.getTagSets());
            buf.append("<tr><td><b>Target key:</b> ").append(sess.getTarget().toBase64().substring(0, 64)).append("<br><b>Established:</b> ").append(DataHelper.formatDuration(now - sess.getEstablishedDate())).append(" ago<br><b>Last Used:</b> ").append(DataHelper.formatDuration(now - sess.getLastUsedDate())).append(" ago<br><b>Session key:</b> ").append(sess.getCurrentKey().toBase64()).append("</td><td><b># Sets:</b> ").append(sess.getTagSets().size()).append("</td></tr><tr><td colspan=\"2\"><ul>");
            for (TagSet ts : sets) {
                int size = ts.getTags().size();
                total += size;
                buf.append("<li><b>Sent:</b> ").append(DataHelper.formatDuration(now - ts.getDate())).append(" ago with ");
                buf.append(size).append(" tags remaining; acked? ").append(ts.getAcked()).append("</li>");
            }
            buf.append("</ul></td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        buf.append("<tr><th colspan=\"2\">Total tags: ").append(total).append(" (");
        buf.append(DataHelper.formatSize(32 * total)).append("B)</th></tr>\n</table>");
        out.write(buf.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TagSet
    implements TagSetHandle {
        private Set<SessionTag> _sessionTags;
        private SessionKey _key;
        private long _date;
        private boolean _acked;

        public TagSet(Set<SessionTag> tags, SessionKey key, long date) {
            if (key == null) {
                throw new IllegalArgumentException("Missing key");
            }
            if (tags == null) {
                throw new IllegalArgumentException("Missing tags");
            }
            this._sessionTags = tags;
            this._key = key;
            this._date = date;
        }

        public long getDate() {
            return this._date;
        }

        void setDate(long when) {
            this._date = when;
        }

        public Set<SessionTag> getTags() {
            return this._sessionTags;
        }

        public SessionKey getAssociatedKey() {
            return this._key;
        }

        public boolean contains(SessionTag tag) {
            return this._sessionTags.contains(tag);
        }

        public void consume(SessionTag tag) {
            this._sessionTags.remove(tag);
        }

        public SessionTag consumeNext() {
            SessionTag first;
            try {
                first = this._sessionTags.iterator().next();
            }
            catch (NoSuchElementException nsee) {
                return null;
            }
            this._sessionTags.remove(first);
            return first;
        }

        public void setAcked() {
            this._acked = true;
        }

        public boolean getAcked() {
            return this._acked;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("TagSet established: ").append(new Date(this._date));
            buf.append(" Session key: ").append(this._key.toBase64());
            buf.append(" Size: ").append(this._sessionTags.size());
            buf.append(" Acked? ").append(this._acked);
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OutboundSession {
        private PublicKey _target;
        private SessionKey _currentKey;
        private long _established;
        private long _lastUsed;
        private List<TagSet> _unackedTagSets;
        private List<TagSet> _tagSets;
        private boolean _acked;

        public OutboundSession(PublicKey target) {
            this(target, null, transientSessionKeyManager._context.clock().now(), transientSessionKeyManager._context.clock().now(), new ArrayList<TagSet>());
        }

        OutboundSession(PublicKey target, SessionKey curKey, long established, long lastUsed, List<TagSet> tagSets) {
            this._target = target;
            this._currentKey = curKey;
            this._established = established;
            this._lastUsed = lastUsed;
            this._unackedTagSets = tagSets;
            this._tagSets = new ArrayList<TagSet>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<TagSet> getTagSets() {
            ArrayList<TagSet> rv;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                rv = new ArrayList<TagSet>(this._unackedTagSets);
                rv.addAll(this._tagSets);
            }
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ackTags(TagSet set) {
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                if (this._unackedTagSets.remove(set)) {
                    this._tagSets.add(set);
                    this._acked = true;
                }
            }
            set.setAcked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void failTags(TagSet set) {
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                this._unackedTagSets.remove(set);
                this._tagSets.remove(set);
            }
        }

        public PublicKey getTarget() {
            return this._target;
        }

        public SessionKey getCurrentKey() {
            return this._currentKey;
        }

        public void setCurrentKey(SessionKey key) {
            this._lastUsed = TransientSessionKeyManager.this._context.clock().now();
            if (this._currentKey != null && !this._currentKey.equals(key)) {
                int dropped = 0;
                List<TagSet> sets = this._tagSets;
                this._tagSets = new ArrayList<TagSet>();
                for (int i = 0; i < sets.size(); ++i) {
                    TagSet set = sets.get(i);
                    dropped += set.getTags().size();
                }
                if (TransientSessionKeyManager.this._log.shouldLog(20)) {
                    TransientSessionKeyManager.this._log.info("Rekeyed from " + this._currentKey + " to " + key + ": dropping " + dropped + " session tags");
                }
            }
            this._currentKey = key;
        }

        public long getEstablishedDate() {
            return this._established;
        }

        public long getLastUsedDate() {
            return this._lastUsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int expireTags() {
            long now = TransientSessionKeyManager.this._context.clock().now();
            int removed = 0;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                for (int i = 0; i < this._tagSets.size(); ++i) {
                    TagSet set = this._tagSets.get(i);
                    if (set.getDate() + 600000L > now) continue;
                    this._tagSets.remove(i);
                    --i;
                    ++removed;
                }
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionTag consumeNext() {
            long now;
            this._lastUsed = now = TransientSessionKeyManager.this._context.clock().now();
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                while (this._tagSets.size() > 0) {
                    TagSet set = this._tagSets.get(0);
                    if (set.getDate() + 600000L > now) {
                        SessionTag tag = set.consumeNext();
                        if (tag != null) {
                            return tag;
                        }
                    } else if (TransientSessionKeyManager.this._log.shouldLog(20)) {
                        TransientSessionKeyManager.this._log.info("TagSet from " + new Date(set.getDate()) + " expired");
                    }
                    this._tagSets.remove(0);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int availableTags() {
            int tags = 0;
            long now = TransientSessionKeyManager.this._context.clock().now();
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                for (int i = 0; i < this._tagSets.size(); ++i) {
                    TagSet set = this._tagSets.get(i);
                    if (set.getDate() + 600000L <= now) continue;
                    int sz = set.getTags().size();
                    if (!set.getAcked()) {
                        sz /= 3;
                    }
                    tags += sz;
                }
            }
            return tags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastExpirationDate() {
            long last = 0L;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                for (TagSet set : this._tagSets) {
                    if (set.getDate() <= last || set.getTags().size() <= 0) continue;
                    last = set.getDate();
                }
            }
            if (last > 0L) {
                return last + 600000L;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTags(TagSet set) {
            this._lastUsed = TransientSessionKeyManager.this._context.clock().now();
            if (this._acked) {
                List<TagSet> list = this._tagSets;
                synchronized (list) {
                    this._tagSets.add(set);
                }
            }
            List<TagSet> list = this._unackedTagSets;
            synchronized (list) {
                this._unackedTagSets.add(set);
            }
        }
    }

    private static class TagSetComparator
    implements Comparator {
        private TagSetComparator() {
        }

        public int compare(Object l, Object r) {
            return (int)(((TagSet)l).getDate() - ((TagSet)r).getDate());
        }
    }

    private class CleanupEvent
    implements SimpleTimer.TimedEvent {
        private CleanupEvent() {
        }

        public void timeReached() {
            if (!TransientSessionKeyManager.this._alive) {
                return;
            }
            long beforeExpire = TransientSessionKeyManager.this._context.clock().now();
            int expired = TransientSessionKeyManager.this.aggressiveExpire();
            long expireTime = TransientSessionKeyManager.this._context.clock().now() - beforeExpire;
            TransientSessionKeyManager.this._context.statManager().addRateData("crypto.sessionTagsExpired", expired, expireTime);
            SimpleScheduler.getInstance().addEvent(this, 60000L);
        }
    }
}

