/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.client.naming.PetName;

public class PetNameDB {
    private final Map _names = Collections.synchronizedMap(new HashMap());
    private String _path;

    public PetName getByName(String name) {
        if (name == null || name.length() <= 0) {
            return null;
        }
        return (PetName)this._names.get(name.toLowerCase());
    }

    public void add(PetName pn) {
        if (pn == null || pn.getName() == null) {
            return;
        }
        this._names.put(pn.getName().toLowerCase(), pn);
    }

    public void clear() {
        this._names.clear();
    }

    public boolean contains(PetName pn) {
        return this._names.containsValue(pn);
    }

    public boolean containsName(String name) {
        if (name == null || name.length() <= 0) {
            return false;
        }
        return this._names.containsKey(name.toLowerCase());
    }

    public boolean isEmpty() {
        return this._names.isEmpty();
    }

    public Iterator iterator() {
        return new ArrayList(this._names.values()).iterator();
    }

    public void remove(PetName pn) {
        if (pn != null) {
            this._names.remove(pn.getName().toLowerCase());
        }
    }

    public void removeName(String name) {
        if (name != null) {
            this._names.remove(name.toLowerCase());
        }
    }

    public int size() {
        return this._names.size();
    }

    public Set getNames() {
        return new HashSet(this._names.keySet());
    }

    public List getGroups() {
        ArrayList<String> rv = new ArrayList<String>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            PetName name = (PetName)iter.next();
            for (int i = 0; i < name.getGroupCount(); ++i) {
                if (rv.contains(name.getGroup(i))) continue;
                rv.add(name.getGroup(i));
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PetName getByLocation(String location) {
        if (location == null) {
            return null;
        }
        Map map = this._names;
        synchronized (map) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                PetName name = (PetName)iter.next();
                if (name.getLocation() == null || !name.getLocation().trim().equals(location.trim())) continue;
                return name;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String location) throws IOException {
        this._path = location;
        File f = new File(location);
        if (!f.exists()) {
            return;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                PetName name = new PetName(line);
                if (name.getName() == null) continue;
                this.add(name);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String location) throws IOException {
        Writer out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(location), "UTF-8");
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                PetName name = (PetName)iter.next();
                if (name == null) continue;
                out.write(name.toString() + "\n");
            }
        }
        finally {
            out.close();
        }
    }

    public void store() throws IOException {
        if (this._path != null) {
            this.store(this._path);
        }
    }
}

