/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyNamingService;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public abstract class NamingService {
    private static final Log _log = new Log(NamingService.class);
    protected I2PAppContext _context;
    private HashMap _cache;
    public static final String PROP_IMPL = "i2p.naming.impl";
    private static final String DEFAULT_IMPL = "net.i2p.client.naming.HostsTxtNamingService";
    protected static final int CACHE_MAX_SIZE = 8;
    protected static final long CACHE_MAX_AGE = 60000L;

    protected NamingService(I2PAppContext context) {
        this._context = context;
        this._cache = new HashMap(8);
    }

    private NamingService() {
    }

    public abstract Destination lookup(String var1);

    public abstract String reverseLookup(Destination var1);

    public String reverseLookup(Hash h) {
        return null;
    }

    protected Destination lookupBase64(String hostname) {
        try {
            Destination result = new Destination();
            result.fromBase64(hostname);
            return result;
        }
        catch (DataFormatException dfe) {
            if (_log.shouldLog(30)) {
                _log.warn("Error translating [" + hostname + "]", dfe);
            }
            return null;
        }
    }

    public static final synchronized NamingService createInstance(I2PAppContext context) {
        NamingService instance = null;
        String impl = context.getProperty(PROP_IMPL, DEFAULT_IMPL);
        try {
            Class<?> cls = Class.forName(impl);
            Constructor<?> con = cls.getConstructor(I2PAppContext.class);
            instance = (NamingService)con.newInstance(context);
        }
        catch (Exception ex) {
            _log.error("Cannot loadNaming service implementation", ex);
            instance = new DummyNamingService(context);
        }
        return instance;
    }

    private void cacheClean() {
        if (this._cache.size() < 8) {
            return;
        }
        boolean full = true;
        Object oldestKey = null;
        long oldestExp = Long.MAX_VALUE;
        ArrayList deleteList = new ArrayList(8);
        for (Map.Entry entry : this._cache.entrySet()) {
            CacheEntry ce = (CacheEntry)entry.getValue();
            if (ce.isExpired()) {
                deleteList.add(entry.getKey());
                full = false;
                continue;
            }
            if (oldestKey != null && ce.exp >= oldestExp) continue;
            oldestKey = entry.getKey();
            oldestExp = ce.exp;
        }
        if (full && oldestKey != null) {
            deleteList.add(oldestKey);
        }
        Iterator iter = deleteList.iterator();
        while (iter.hasNext()) {
            this._cache.remove(iter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putCache(String s, Destination d) {
        if (d == null) {
            return;
        }
        HashMap hashMap = this._cache;
        synchronized (hashMap) {
            this._cache.put(s, new CacheEntry(d));
            this.cacheClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination getCache(String s) {
        HashMap hashMap = this._cache;
        synchronized (hashMap) {
            CacheEntry ce = (CacheEntry)this._cache.get(s);
            if (ce == null) {
                return null;
            }
            if (ce.isExpired()) {
                this._cache.remove(s);
                return null;
            }
            return ce.dest;
        }
    }

    private class CacheEntry {
        public Destination dest;
        public long exp;

        public CacheEntry(Destination d) {
            this.dest = d;
            this.exp = NamingService.this._context.clock().now() + 60000L;
        }

        public boolean isExpired() {
            return this.exp < NamingService.this._context.clock().now();
        }
    }
}

