/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.InputStream;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.NamingService;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class ExecNamingService
extends NamingService {
    private static final String PROP_EXEC_CMD = "i2p.naming.exec.command";
    private static final String DEFAULT_EXEC_CMD = "/usr/local/bin/i2presolve";
    private static final String PROP_SHELL_CMD = "i2p.naming.exec.shell";
    private static final String DEFAULT_SHELL_CMD = "/bin/bash";
    private static final Log _log = new Log(ExecNamingService.class);
    private static final int DEST_SIZE = 516;
    private static final int MAX_RESPONSE = 594;

    public ExecNamingService(I2PAppContext context) {
        super(context);
    }

    public Destination lookup(String hostname) {
        if (hostname.length() >= 516) {
            return this.lookupBase64(hostname);
        }
        Destination d = this.getCache(hostname = hostname.toLowerCase());
        if (d != null) {
            return d;
        }
        String key = this.fetchAddr(hostname);
        if (key != null) {
            _log.error("Success: " + hostname);
            d = this.lookupBase64(key);
            this.putCache(hostname, d);
            return d;
        }
        return null;
    }

    private String fetchAddr(String hostname) {
        String command;
        String[] commandArr = new String[]{this._context.getProperty(PROP_SHELL_CMD, DEFAULT_SHELL_CMD), "-c", command = this._context.getProperty(PROP_EXEC_CMD, DEFAULT_EXEC_CMD) + " " + hostname};
        try {
            Process get = Runtime.getRuntime().exec(commandArr);
            get.waitFor();
            int exitValue = get.exitValue();
            if (exitValue != 0) {
                _log.error("Exit " + exitValue + " from " + commandArr[0] + " " + commandArr[1] + " \"" + command + "\"");
                return null;
            }
            InputStream is = get.getInputStream();
            byte[] input = new byte[594];
            int count = is.read(input);
            is.close();
            if (count < 516) {
                _log.error("Short response: " + command);
                return null;
            }
            String key = new String(input);
            if (key.startsWith(hostname + "=")) {
                key = key.substring(hostname.length() + 1);
            }
            if (!(key = key.substring(0, 516)).endsWith("AA")) {
                _log.error("Invalid key: " + command);
                return null;
            }
            if (key.replaceAll("[a-zA-Z0-9~-]", "").length() != 0) {
                _log.error("Invalid chars: " + command);
                return null;
            }
            return key;
        }
        catch (Throwable t) {
            _log.error("Error fetching the addr", t);
            return null;
        }
    }

    public String reverseLookup(Destination dest) {
        return null;
    }
}

