/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.NamingService;
import net.i2p.data.Destination;
import net.i2p.util.EepGet;
import net.i2p.util.Log;

public class EepGetNamingService
extends NamingService {
    private static final String PROP_EEPGET_LIST = "i2p.naming.eepget.list";
    private static final String DEFAULT_EEPGET_LIST = "http://i2host.i2p/cgi-bin/i2hostquery?";
    private static final Log _log = new Log(EepGetNamingService.class);
    private static final int DEST_SIZE = 516;
    private static final int MAX_RESPONSE = 594;

    public EepGetNamingService(I2PAppContext context) {
        super(context);
    }

    private List getURLs() {
        String list = this._context.getProperty(PROP_EEPGET_LIST, DEFAULT_EEPGET_LIST);
        StringTokenizer tok = new StringTokenizer(list, ",");
        ArrayList<String> rv = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            rv.add(tok.nextToken());
        }
        return rv;
    }

    public Destination lookup(String hostname) {
        String url;
        int i;
        if (hostname.length() >= 516) {
            return this.lookupBase64(hostname);
        }
        Destination d = this.getCache(hostname = hostname.toLowerCase());
        if (d != null) {
            return d;
        }
        List URLs = this.getURLs();
        if (URLs.size() == 0) {
            return null;
        }
        for (i = 0; i < URLs.size(); ++i) {
            url = (String)URLs.get(i);
            if (!url.startsWith("http://" + hostname + "/")) continue;
            _log.error("Lookup loop: " + hostname);
            return null;
        }
        for (i = 0; i < URLs.size(); ++i) {
            url = (String)URLs.get(i);
            String key = this.fetchAddr(url, hostname);
            if (key == null) continue;
            _log.error("Success: " + url + hostname);
            d = this.lookupBase64(key);
            this.putCache(hostname, d);
            return d;
        }
        return null;
    }

    private String fetchAddr(String url, String hostname) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(594);
        try {
            EepGet get = new EepGet(this._context, true, "localhost", 4444, 0, 516L, 594L, null, baos, url + hostname, false, null, null);
            if (get.fetch(10000L, 15000L, -1L)) {
                if (baos.size() < 516) {
                    _log.error("Short response: " + url + hostname);
                    return null;
                }
                String key = baos.toString();
                if (key.startsWith(hostname + "=")) {
                    key = key.substring(hostname.length() + 1);
                }
                if (!(key = key.substring(0, 516)).endsWith("AA")) {
                    _log.error("Invalid key: " + url + hostname);
                    return null;
                }
                if (key.replaceAll("[a-zA-Z0-9~-]", "").length() != 0) {
                    _log.error("Invalid chars: " + url + hostname);
                    return null;
                }
                return key;
            }
            _log.error("Fetch failed from: " + url + hostname);
            return null;
        }
        catch (Throwable t) {
            _log.error("Error fetching the addr", t);
            _log.error("Caught from: " + url + hostname);
            return null;
        }
    }

    public String reverseLookup(Destination dest) {
        return null;
    }
}

