/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.service;

import com.nettgryppa.security.HashCash;
import i2p.bote.Configuration;
import i2p.bote.folder.PacketFolder;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.packet.RelayPacket;
import i2p.bote.service.I2PBoteThread;
import java.text.ParseException;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelayPacketSender
extends I2PBoteThread {
    private static final int PAUSE = 600000;
    private static final int PADDED_SIZE = 16384;
    private static final Log log = new Log(RelayPacketSender.class);
    private I2PSendQueue sendQueue;
    private I2PAppContext appContext;
    private PacketFolder<RelayPacket> packetStore;
    private Configuration configuration;

    public RelayPacketSender(I2PSendQueue sendQueue, PacketFolder<RelayPacket> packetStore, I2PAppContext appContext) {
        super("RelayPacketSender");
        this.sendQueue = sendQueue;
        this.packetStore = packetStore;
        this.appContext = appContext;
    }

    public void run() {
        while (true) {
            if (log.shouldLog(10)) {
                log.debug("Deleting expired packets...");
            }
            try {
                this.deleteExpiredPackets();
            }
            catch (Exception e) {
                log.error("Error deleting expired packets", (Throwable)e);
            }
            log.info("Processing outgoing packets in directory '" + this.packetStore.getStorageDirectory().getAbsolutePath() + "'");
            for (RelayPacket packet : this.packetStore) {
                log.info("Processing packet file: <" + packet.getFile() + ">");
                try {
                    HashCash hashCash = null;
                    long sendTime = this.getRandomSendTime(packet);
                    this.sendQueue.sendRelayRequest(packet, hashCash, sendTime);
                }
                catch (Exception e) {
                    log.error("Error sending packet. ", (Throwable)e);
                }
            }
            try {
                Thread.sleep(600000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("RelayPacketSender received an InterruptedException.");
                continue;
            }
            break;
        }
    }

    private long getRandomSendTime(RelayPacket packet) {
        long min = packet.getEarliestSendTime();
        long max = packet.getLatestSendTime();
        return min + RandomSource.getInstance().nextLong(max - min);
    }

    public void deleteExpiredPackets() throws ParseException {
    }
}

