/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.service;

import com.nettgryppa.security.HashCash;
import i2p.bote.Configuration;
import i2p.bote.email.Email;
import i2p.bote.email.EmailDestination;
import i2p.bote.folder.Outbox;
import i2p.bote.network.DHT;
import i2p.bote.network.EmailAddressResolver;
import i2p.bote.network.PeerManager;
import i2p.bote.packet.EncryptedEmailPacket;
import i2p.bote.packet.IndexPacket;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboxProcessor
extends I2PAppThread {
    private static final int PAUSE = 10;
    private Log log = new Log(OutboxProcessor.class);
    private DHT dht;
    private Outbox outbox;
    private Configuration configuration;
    private I2PAppContext appContext;
    private EmailAddressResolver emailAddressResolver;
    private Map<EmailDestination, String> statusMap;
    private CountDownLatch checkForEmailSignal;

    public OutboxProcessor(DHT dht, Outbox outbox, Configuration configuration, PeerManager peerManager, I2PAppContext appContext) {
        super("OutboxProcsr");
        this.dht = dht;
        this.outbox = outbox;
        this.configuration = configuration;
        this.appContext = appContext;
        this.statusMap = new ConcurrentHashMap();
        this.emailAddressResolver = new EmailAddressResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            OutboxProcessor outboxProcessor = this;
            synchronized (outboxProcessor) {
                this.checkForEmailSignal = new CountDownLatch(1);
            }
            this.log.info("Processing outgoing emails in directory '" + this.outbox.getStorageDirectory() + "'.");
            for (Email email : this.outbox) {
                this.log.info("Processing outbox file: '" + email.getFile() + "'.");
                try {
                    this.sendEmail(email);
                }
                catch (Exception e) {
                    this.log.error("Error sending email.", (Throwable)e);
                }
            }
            try {
                this.checkForEmailSignal.await(10L, TimeUnit.MINUTES);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error("OutboxProcessor received an InterruptedException.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void checkForEmail() {
        this.checkForEmailSignal.countDown();
    }

    private void sendEmail(Email email) throws IOException {
        for (String recipient : email.getAllRecipients()) {
            this.sendToOne(recipient, email);
        }
    }

    private void sendToOne(String address, Email email) {
        String logSuffix = null;
        try {
            Email scrubbedEmail = email.removeBCCs(address);
            this.addHashCash(email);
            logSuffix = "Recipient = '" + address + "' Message ID = '" + email.getMessageID() + "'";
            EmailDestination emailDestination = this.emailAddressResolver.getDestination(address);
            Collection emailPackets = email.createEmailPackets(address);
            Collection encryptedPackets = EncryptedEmailPacket.encrypt((Collection)emailPackets, (EmailDestination)emailDestination, (I2PAppContext)this.appContext);
            for (EncryptedEmailPacket packet : encryptedPackets) {
                this.dht.store((DhtStorablePacket)packet);
            }
            this.dht.store((DhtStorablePacket)new IndexPacket(encryptedPackets, emailDestination));
            this.outbox.updateStatus(email, new int[]{1}, "Email sent to recipient: " + address);
        }
        catch (Exception e) {
            this.log.error("Error trying to send email. " + logSuffix);
            this.outbox.updateStatus(email, new int[]{1}, "Error trying to send email to recipient: " + address);
            return;
        }
    }

    private void addHashCash(Email email) throws NoSuchAlgorithmException {
        email.setHashCash(HashCash.mintCash((String)"", (int)this.configuration.getHashCashStrength()));
    }

    public Map<EmailDestination, String> getStatus() {
        return this.statusMap;
    }

    public void shutDown() {
    }
}

