/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet.dht;

import i2p.bote.I2PBote;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.I2PBotePacket;
import i2p.bote.packet.TypeCode;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.i2p.data.Hash;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TypeCode(value=81)
public class RetrieveRequest
extends CommunicationPacket {
    private Log log = new Log(I2PBote.class);
    private Hash key;
    private Class<? extends DhtStorablePacket> dataType;

    public RetrieveRequest(Hash key, Class<? extends DhtStorablePacket> dataType) {
        this.key = key;
        this.dataType = dataType;
    }

    public RetrieveRequest(byte[] data) {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 38, data.length - 38);
        char dataTypeCode = (char)buffer.get();
        this.dataType = DhtStorablePacket.decodePacketTypeCode((char)dataTypeCode);
        byte[] keyBytes = new byte[32];
        buffer.get(keyBytes);
        this.key = new Hash(keyBytes);
        if (buffer.hasRemaining()) {
            this.log.debug("Retrieve Request Packet has " + buffer.remaining() + " extra bytes.");
        }
    }

    public Hash getKey() {
        return this.key;
    }

    public Class<? extends I2PBotePacket> getDataType() {
        return this.dataType;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.writeHeader((OutputStream)outputStream);
            outputStream.write(this.getPacketTypeCode(this.dataType));
            outputStream.write(this.key.toByteArray());
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return outputStream.toByteArray();
    }

    public String toString() {
        return super.toString() + ", DhtKey=" + this.key.toBase64();
    }
}

