/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.UniqueId;
import i2p.bote.Util;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.i2p.util.Log;

@TypeCode(value=85)
public class UnencryptedEmailPacket
extends DataPacket {
    private Log log = new Log(UnencryptedEmailPacket.class);
    private UniqueId deletionKeyPlain;
    private UniqueId deletionKeyVerify;
    private UniqueId messageId;
    private int fragmentIndex;
    private int numFragments;
    private byte[] content;

    public UnencryptedEmailPacket(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        if (buffer.get() != this.getPacketTypeCode()) {
            this.log.error("Wrong type code for UnencryptedEmailPacket. Expected <" + this.getPacketTypeCode() + ">, got <" + (char)data[0] + ">");
        }
        this.deletionKeyPlain = new UniqueId(buffer);
        this.deletionKeyVerify = new UniqueId(buffer);
        this.messageId = new UniqueId(buffer);
        this.fragmentIndex = buffer.getShort();
        this.numFragments = buffer.getShort();
        short contentLength = buffer.getShort();
        this.content = new byte[contentLength];
        buffer.get(this.content);
    }

    public UnencryptedEmailPacket(InputStream inputStream) throws IOException {
        this(Util.readInputStream((InputStream)inputStream));
    }

    public UnencryptedEmailPacket(UniqueId deletionKeyPlain, UniqueId deletionKeyVerify, UniqueId messageId, int fragmentIndex, int numFragments, byte[] content) {
        this.deletionKeyPlain = deletionKeyPlain;
        this.deletionKeyVerify = deletionKeyVerify;
        this.messageId = messageId;
        this.fragmentIndex = fragmentIndex;
        this.numFragments = numFragments;
        this.content = content;
        this.verify();
    }

    public UniqueId getPlaintextDeletionKey() {
        return this.deletionKeyPlain;
    }

    public UniqueId getVerificationDeletionKey() {
        return this.deletionKeyVerify;
    }

    public UniqueId getMessageId() {
        return this.messageId;
    }

    public int getFragmentIndex() {
        return this.fragmentIndex;
    }

    public void setNumFragments(int numFragments) {
        this.numFragments = numFragments;
    }

    public int getNumFragments() {
        return this.numFragments;
    }

    public byte[] getContent() {
        return this.content;
    }

    private void verify() {
        if (this.fragmentIndex < 0 || this.fragmentIndex >= this.numFragments || this.numFragments < 1) {
            this.log.error("Illegal values: fragmentIndex=" + this.fragmentIndex + " numFragments=" + this.numFragments);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteArrayStream);
        try {
            dataStream.write((byte)this.getPacketTypeCode());
            this.deletionKeyPlain.writeTo((OutputStream)dataStream);
            this.deletionKeyVerify.writeTo((OutputStream)dataStream);
            this.messageId.writeTo((OutputStream)dataStream);
            dataStream.writeShort(this.fragmentIndex);
            dataStream.writeShort(this.numFragments);
            dataStream.writeShort(this.content.length);
            dataStream.write(this.content);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return byteArrayStream.toByteArray();
    }

    public String toString() {
        return "Type=" + UnencryptedEmailPacket.class.getSimpleName() + ", delKeyPln=" + this.deletionKeyPlain + ", delKeyVfy=" + this.deletionKeyVerify + ", msgId=" + this.messageId + ", fragIdx=" + this.fragmentIndex + ", numFrags=" + this.numFragments + ", contLen=" + this.content.length;
    }
}

